/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthTable;

public class HarmonicTable
extends SynthTable {
    public short[] data;
    double[] partials;
    double[] samples;
    int numPartials;
    int numSamples;
    double minVal = 0.0;
    double maxVal = 0.0;

    public HarmonicTable(int numSamples, int numPartials) throws SynthException {
        super(numSamples);
        this.partials = new double[numPartials];
        this.samples = new double[numSamples];
        this.data = new short[numSamples];
        this.numSamples = numSamples;
        this.numPartials = numPartials;
        this.clear();
    }

    public void setPartial(int index, double amplitude) {
        this.partials[index] = amplitude;
    }

    public double getPartial(int index) {
        return this.partials[index];
    }

    public int getNumPartials() {
        return this.numPartials;
    }

    void addHarmonics() {
        int i = 0;
        while (i < this.numSamples - 1) {
            double sum = 0.0;
            int h = 0;
            while (h < this.numPartials) {
                double sinVal = Math.sin((double)(h + 1) * (Math.PI * 2 * (double)i / (double)(this.numSamples - 1)));
                sum += this.partials[h] * sinVal;
                ++h;
            }
            this.samples[i] = sum;
            ++i;
        }
        this.samples[this.numSamples - 1] = this.samples[0];
    }

    void findMinMax() {
        this.minVal = Double.MAX_VALUE;
        this.maxVal = Double.MIN_VALUE;
        int i = 0;
        while (i < this.numSamples) {
            double curVal = this.samples[i];
            if (curVal < this.minVal) {
                this.minVal = curVal;
            }
            if (curVal > this.maxVal) {
                this.maxVal = curVal;
            }
            ++i;
        }
    }

    void scale(double scalar) {
        int i = 0;
        while (i < this.numSamples) {
            int n = i++;
            this.samples[n] = this.samples[n] * scalar;
        }
    }

    void normalize() {
        this.findMinMax();
        double absMax = Math.max(Math.abs(this.minVal), Math.abs(this.maxVal));
        if (absMax < 0.001) {
            absMax = 0.001;
        }
        double scalar = 1.0 / absMax;
        this.scale(scalar);
    }

    public void build() {
        this.addHarmonics();
        this.normalize();
        this.write(this.samples);
        int i = 0;
        while (i < this.numSamples) {
            this.data[i] = (short)(32767.0 * this.samples[i]);
            ++i;
        }
    }

    public void square() {
        int h = 0;
        while (h < this.numPartials) {
            double part = (h & 1) == 1 ? 0.0 : 2.0 / (Math.PI * (double)(h + 1));
            this.partials[h] = part;
            ++h;
        }
        this.build();
    }

    public void triangle() {
        int h = 0;
        while (h < this.numPartials) {
            double part = (h & 1) == 1 ? 0.0 : 1.0 / (double)((h + 1) * (h + 1));
            this.partials[h] = part;
            ++h;
        }
        this.build();
    }

    public void sawtooth() {
        int h = 0;
        while (h < this.numPartials) {
            double part = 1.0 / (double)(h + 1);
            if ((h & 1) == 1) {
                part = -part;
            }
            this.partials[h] = part;
            ++h;
        }
        this.build();
    }

    public void clear() {
        int h = 0;
        while (h < this.numPartials) {
            this.partials[h] = 0.0;
            ++h;
        }
        this.build();
    }
}

