/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.view.Tweakable;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;

public class LabelledFader
extends Panel
implements Tweakable {
    Tweakable target;
    int targetIndex;
    String faderName;
    Scrollbar fader;
    Label nameLabel;
    Label valueLabel;
    double min;
    double max;
    static final int RANGE = 200;

    public LabelledFader(Tweakable target, int targetIndex, String faderName, double startValue, double min, double max) {
        this.target = target == null ? this : target;
        this.targetIndex = targetIndex;
        this.faderName = faderName;
        this.min = min;
        this.max = max;
        this.setLayout(new GridLayout(0, 3));
        this.nameLabel = new Label(String.valueOf(faderName) + " ", 2);
        this.add(this.nameLabel);
        int visible = 20;
        this.fader = new Scrollbar(0, this.doubleToFader(startValue), visible, 0, 200 + visible);
        this.add(this.fader);
        this.valueLabel = new Label();
        this.showValue(startValue);
        this.add(this.valueLabel);
    }

    double faderToDouble(int val) {
        return (double)val * (this.max - this.min) / 200.0 + this.min;
    }

    int doubleToFader(double fval) {
        return (int)((fval - this.min) * 200.0 / (this.max - this.min));
    }

    void showValue(double fval) {
        String fvalString = Double.toString(fval);
        int maxchars = fvalString.indexOf(46) + 5;
        String actualString = fvalString.length() > maxchars ? fvalString.substring(0, maxchars) : fvalString;
        this.valueLabel.setText(actualString);
    }

    @Override
    public void tweak(int idx, double fval) {
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.target == this.fader) {
            switch (evt.id) {
                case 601: 
                case 602: 
                case 603: 
                case 604: 
                case 605: {
                    int val = this.fader.getValue();
                    double fval = this.faderToDouble(val);
                    this.target.tweak(this.targetIndex, fval);
                    this.showValue(fval);
                    this.repaint();
                }
            }
            return true;
        }
        return super.handleEvent(evt);
    }
}

