/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.view102.XYController;
import java.awt.Color;
import java.awt.Graphics;

public class InternalBarGraphEditor
extends XYController {
    double[] data;
    int numValues;
    int previousHighlightIndex = -1;

    public InternalBarGraphEditor(double[] data) {
        this.setArray(data);
    }

    public void setArray(double[] data) {
        this.data = data;
        this.numValues = data.length;
        this.setMaxWorldX(this.numValues);
    }

    void drawHighlight(Graphics g, int idx) {
        int width = this.bounds().width;
        int height = this.bounds().height;
        int barWidth = width / this.numValues;
        int x = this.convertWXtoGX(idx);
        g.setXORMode(Color.orange);
        g.fillRect(x, 0, barWidth, height);
        g.setPaintMode();
    }

    public void highlight(int idx) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.previousHighlightIndex >= 0) {
            this.drawHighlight(g, this.previousHighlightIndex);
        }
        this.drawHighlight(g, idx);
        this.previousHighlightIndex = idx;
    }

    void updateDrawing(int idx, double oldVal, double val) {
        int x;
        int y2;
        int y1;
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        int width = this.bounds().width;
        int barWidth = width / this.numValues - 4;
        if (barWidth < 3) {
            barWidth = 3;
        }
        if ((y1 = this.convertWYtoGY(oldVal)) > (y2 = this.convertWYtoGY(val))) {
            x = y1;
            y1 = y2;
            y2 = x;
        }
        if (y1 != y2) {
            x = this.convertWXtoGX(idx) + 2;
            g.setXORMode(this.getBackground());
            g.fillRect(x, y1, barWidth, y2 - y1);
            g.setPaintMode();
        }
    }

    protected void convertMouse(boolean isShiftDown, int x, int y) {
        int idx = (int)this.convertGXtoWX(x);
        if (idx < 0) {
            idx = 0;
        } else if (idx >= this.numValues) {
            idx = this.numValues - 1;
        }
        double val = isShiftDown ? this.minWorldY + Math.random() * (this.maxWorldY - this.minWorldY) : this.clipWorldY(this.convertGYtoWY(y));
        double oldVal = this.data[idx];
        this.data[idx] = val;
        if (oldVal != val) {
            this.updateDrawing(idx, oldVal, val);
        }
    }

    @Override
    public void paint(Graphics g) {
        int width = this.bounds().width;
        int height = this.bounds().height;
        int barWidth = width / this.numValues - 4;
        if (barWidth < 3) {
            barWidth = 3;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        g.setColor(this.getForeground());
        int i = 0;
        while (i < this.numValues) {
            int x = this.convertWXtoGX(i) + 2;
            int y = this.convertWYtoGY(this.data[i]);
            g.fillRect(x, y, barWidth, height - y);
            ++i;
        }
        this.previousHighlightIndex = -1;
    }
}

