/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view11x;

import com.softsynth.jsyn.util.HarmonicTable;
import com.softsynth.jsyn.view11x.HarmonicFader;
import com.softsynth.jsyn.view11x.WaveDisplay;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WaveMaker
extends Panel {
    HarmonicTable table;
    HarmonicFader[] faders;
    int numSamples;
    int numPartials;
    public short[] data;
    Button sawButton;
    Button squareButton;
    Button triButton;
    Button clearButton;
    double minVal = 0.0;
    double maxVal = 0.0;
    WaveDisplay display;

    public WaveMaker(HarmonicTable table, WaveDisplay display) {
        this.table = table;
        this.display = display;
        this.numSamples = table.length();
        this.numPartials = table.getNumPartials();
        this.data = new short[this.numSamples];
        this.faders = new HarmonicFader[this.numPartials];
        this.setLayout(new GridLayout(1, 0));
        int i = 0;
        while (i < this.numPartials) {
            this.faders[i] = new HarmonicFader(this, i);
            this.add(this.faders[i]);
            ++i;
        }
        this.sawButton = new Button("Saw");
        this.add(this.sawButton);
        this.sawButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveMaker.this.handleSawtoothButton();
            }
        });
        this.squareButton = new Button("Sqr");
        this.add(this.squareButton);
        this.squareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveMaker.this.handleSquareButton();
            }
        });
        this.triButton = new Button("Tri");
        this.add(this.triButton);
        this.triButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveMaker.this.handleTriButton();
            }
        });
        this.clearButton = new Button("Clr");
        this.add(this.clearButton);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveMaker.this.handleClearButton();
            }
        });
        table.clear();
        this.updateFaders();
    }

    void handleSawtoothButton() {
        this.table.sawtooth();
        this.updateFaders();
        this.display.repaint();
    }

    void handleSquareButton() {
        this.table.square();
        this.updateFaders();
        this.display.repaint();
    }

    void handleTriButton() {
        this.table.triangle();
        this.updateFaders();
        this.display.repaint();
    }

    void handleClearButton() {
        this.table.clear();
        this.updateFaders();
        this.display.repaint();
    }

    void setPartial(int index, double value) {
        this.table.setPartial(index, value);
        this.table.build();
        this.display.repaint();
    }

    void updateFaders() {
        int h = 0;
        while (h < this.numPartials) {
            this.faders[h].setValue(this.table.getPartial(h));
            ++h;
        }
    }
}

