/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

public class AudioMath {
    private static final double a2dScalar = 20.0 / Math.log(10.0);
    public static final int CONCERT_A_PITCH = 69;
    public static final double CONCERT_A_FREQUENCY = 440.0;

    public static double amplitudeToDecibels(double amplitude) {
        double db = Math.log(amplitude) * a2dScalar;
        return db;
    }

    public static double decibelsToAmplitude(double decibels) {
        double amp = Math.pow(10.0, decibels / 20.0);
        return amp;
    }

    public static double frequencyToPitch(double frequency) {
        return 69.0 + 12.0 * Math.log(frequency / 440.0) / Math.log(2.0);
    }

    public static double pitchToFrequency(double pitch) {
        return 440.0 * Math.pow(2.0, (pitch - 69.0) * 0.08333333333333333);
    }
}

