/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.midifile;

import com.softsynth.midifile.MIDIFileListener;
import com.softsynth.midifile.MIDIStandard;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class MIDIFileInputStream
extends BufferedInputStream {
    Vector listeners = new Vector();
    int format;
    int numTracks;
    short division;
    int bytesRead;
    int lastCommand = 0;

    public MIDIFileInputStream(InputStream stream) {
        super(stream);
    }

    public void addMIDIFileListener(MIDIFileListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeMIDIFileListener(MIDIFileListener listener) {
        this.listeners.removeElement(listener);
    }

    @Override
    public int read() throws IOException {
        int data = super.read();
        ++this.bytesRead;
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i = 0;
        while (i < b.length) {
            int data = this.read();
            if (data == -1) {
                return -1;
            }
            b[i] = (byte)data;
            ++i;
        }
        return b.length;
    }

    public int readIntBig() throws IOException {
        int result = this.read() & 0xFF;
        result = result << 8 | this.read() & 0xFF;
        result = result << 8 | this.read() & 0xFF;
        int data = this.read();
        if (data == -1) {
            throw new EOFException();
        }
        result = result << 8 | data & 0xFF;
        return result;
    }

    public short readShortBig() throws IOException {
        short result = (short)(this.read() << 8);
        int data = this.read();
        if (data == -1) {
            throw new EOFException();
        }
        result = (short)(result | data & 0xFF);
        return result;
    }

    public static String IDToString(int ID) {
        byte[] bar = new byte[]{(byte)(ID >> 24), (byte)(ID >> 16), (byte)(ID >> 8), (byte)ID};
        return new String(bar);
    }

    int parseVariableLengthQuantity() throws IOException {
        int data;
        int value = 0;
        do {
            data = this.read();
            value = (value << 7) + (data & 0x7F);
        } while ((data & 0x80) == 128);
        return value;
    }

    void parseTrack(int index) throws IOException {
        int ticks = 0;
        int ID = this.readIntBig();
        if (ID != 1297379947) {
            throw new RuntimeException("Invalid MIDI file. Not an MTrk chunk.");
        }
        int chunkLen = this.readIntBig();
        int byteLimit = chunkLen + this.bytesRead;
        this.handleBeginTrack(index);
        while (this.bytesRead < byteLimit) {
            int deltaTime = this.parseVariableLengthQuantity();
            ticks += deltaTime;
            int command = this.read();
            switch (command) {
                case 255: {
                    this.parseMetaEvent(ticks);
                    break;
                }
                case 240: {
                    this.handleSysExF0(ticks, this.parseVariableBytes());
                    break;
                }
                case 247: {
                    this.handleSysExF0(ticks, this.parseVariableBytes());
                    break;
                }
                default: {
                    this.parseEvent(ticks, command);
                }
            }
        }
        this.handleEndTrack(index);
    }

    byte[] parseVariableBytes() throws IOException {
        byte[] bytes = null;
        int length = this.parseVariableLengthQuantity();
        if (length > 0) {
            bytes = new byte[length];
            this.read(bytes);
        }
        return bytes;
    }

    void parseMetaEvent(int ticks) throws IOException {
        int type = this.read();
        this.handleMetaEvent(ticks, type, this.parseVariableBytes());
    }

    public void handleHeader(int format, int numTracks, short division) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((MIDIFileListener)e.nextElement()).handleHeader(format, numTracks, division);
        }
    }

    public void handleBeginTrack(int index) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((MIDIFileListener)e.nextElement()).handleBeginTrack(index);
        }
    }

    public void handleEndTrack(int index) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((MIDIFileListener)e.nextElement()).handleEndTrack(index);
        }
    }

    public void handleSysExF0(int ticks, byte[] b) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((MIDIFileListener)e.nextElement()).handleSysExF0(ticks, b);
        }
    }

    public void handleSysExF7(int ticks, byte[] b) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((MIDIFileListener)e.nextElement()).handleSysExF7(ticks, b);
        }
    }

    public void handleMetaEvent(int ticks, int type, byte[] b) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((MIDIFileListener)e.nextElement()).handleMetaEvent(ticks, type, b);
        }
    }

    void handleEvent(int ticks, int command, int data1, int data2) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((MIDIFileListener)e.nextElement()).handleEvent(ticks, command, data1, data2);
        }
    }

    void parseEvent(int ticks, int command) throws IOException {
        boolean isRunningStatus;
        int data1 = 0;
        int data2 = 0;
        int bytesReadInMessage = 1;
        boolean bl = isRunningStatus = command < 128;
        if (isRunningStatus) {
            data1 = command;
            command = this.lastCommand;
            bytesReadInMessage = 2;
        }
        this.lastCommand = command;
        int bytesPerMessage = MIDIStandard.bytesPerMessage(command);
        if (!isRunningStatus && bytesPerMessage > bytesReadInMessage) {
            data1 = this.read();
            ++bytesReadInMessage;
        }
        if (bytesPerMessage > bytesReadInMessage) {
            data2 = this.read();
            ++bytesReadInMessage;
        }
        this.handleEvent(ticks, command, data1, data2);
    }

    void parseTracks() throws IOException {
        int i = 0;
        while (i < this.numTracks) {
            this.parseTrack(i);
            ++i;
        }
    }

    void parseHeader() throws IOException {
        int ID = this.readIntBig();
        if (ID != 1297377380) {
            throw new RuntimeException("Not a MIDI file. No MThd chunk.");
        }
        int chunkLen = this.readIntBig();
        if (chunkLen != 6) {
            throw new RuntimeException("Not a valid MIDI file. MThd chunk len is " + chunkLen);
        }
        this.format = this.readShortBig();
        this.numTracks = this.readShortBig();
        this.division = this.readShortBig();
        this.handleHeader(this.format, this.numTracks, this.division);
    }

    public void parse() throws IOException {
        this.parseHeader();
        this.parseTracks();
    }
}

