/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.midifile;

import com.softsynth.midifile.MIDIStandard;
import com.softsynth.midifile.MacFileTyper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MIDIFileOutput
extends RandomAccessFile {
    long trackLengthOffset;
    int trackTime;
    int lastCommand = 0;

    public MIDIFileOutput(File file) throws IOException {
        super(file, "rw");
        try {
            MacFileTyper.setMacInfo(file);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public MIDIFileOutput(String fileName) throws IOException {
        this(new File(fileName));
    }

    void writeVariableLengthPart(int val, int mask) throws IOException {
        int data = val & 0x7F;
        if ((val >>= 7) > 0) {
            this.writeVariableLengthPart(val, 128);
        }
        this.write(data | mask);
    }

    public void writeVariableLengthQuantity(int val) throws IOException {
        this.writeVariableLengthPart(val, 0);
    }

    public void writeHeader(int format, int numTracks, short division) throws IOException {
        this.writeInt(1297377380);
        this.writeInt(6);
        this.writeShort(format);
        this.writeShort(numTracks);
        this.writeShort(division);
    }

    public void startTrack() throws IOException {
        this.trackTime = 0;
        this.writeInt(1297379947);
        this.trackLengthOffset = this.getFilePointer();
        this.writeInt(0);
    }

    public void writeEndOfTrack(int time) throws IOException {
        this.writeTime(time);
        this.write(255);
        this.write(47);
        this.write(0);
    }

    public void finishTrack() throws IOException {
        long endOfTrack = this.getFilePointer();
        int size = (int)(endOfTrack - this.trackLengthOffset - 4L);
        this.seek(this.trackLengthOffset);
        this.writeInt(size);
        this.seek(endOfTrack);
    }

    public void writeTime(int time) throws IOException {
        int duration = time - this.trackTime;
        if (duration < 0) {
            throw new RuntimeException("Events out of time order.");
        }
        this.writeVariableLengthQuantity(duration);
        this.trackTime = time;
    }

    public void writeSysExEvent(int time, byte[] b) throws IOException {
        this.writeTime(time);
        this.write(240);
        this.writeVariableLengthQuantity(b.length);
        this.write(b);
    }

    public void writeSysExEventF7(int time, byte[] b) throws IOException {
        this.writeTime(time);
        this.write(247);
        this.writeVariableLengthQuantity(b.length);
        this.write(b);
    }

    public void writeMetaEvent(int time, int type, byte[] b) throws IOException {
        this.writeTime(time);
        this.write(255);
        this.write(type);
        if (b == null) {
            this.write(0);
        } else {
            this.writeVariableLengthQuantity(b.length);
            this.write(b);
        }
    }

    public void writeEvent(int time, int command, int data1, int data2) throws IOException {
        this.writeTime(time);
        this.write(command);
        int numBytes = MIDIStandard.bytesPerMessage(command);
        if (numBytes > 1) {
            this.write(data1);
        }
        if (numBytes > 2) {
            this.write(data2);
        }
    }

    private void test1() throws IOException {
        this.writeHeader(1, 1, (short)100);
        this.startTrack();
        this.writeEvent(0, 144, 80, 64);
        this.writeEvent(100, 128, 80, 64);
        this.writeEvent(200, 144, 87, 64);
        this.writeEvent(300, 128, 87, 64);
        this.writeEndOfTrack(400);
        this.finishTrack();
        this.close();
    }

    public static void main(String[] args) {
        try {
            MIDIFileOutput mfout = new MIDIFileOutput("testout.mid");
            mfout.test1();
        }
        catch (SecurityException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println("Caught " + e);
            e.printStackTrace();
        }
    }
}

