/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.midifile;

import com.softsynth.midifile.MIDIFileEvent;
import com.softsynth.midifile.MIDIFileOutput;
import com.softsynth.util.NumericOutput;
import java.io.IOException;

public class MIDIFileSysExEvent
extends MIDIFileEvent {
    public byte[] bytes;

    public MIDIFileSysExEvent(int ticks, int command, byte[] b) {
        super(ticks, command, 0, 0);
        this.bytes = b;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void write(MIDIFileOutput mfout) throws IOException {
        mfout.writeSysExEvent(this.ticks, this.bytes);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTimeString()) + "MIDI SysEx( 0x" + NumericOutput.integerToString(this.command, 2, true, 16) + ", " + (this.bytes == null ? "null" : Integer.toString(this.bytes.length)) + " )";
    }
}

