/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.unitgen.LineOut;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.compose.swing.BasicScoreInstrument;
import com.softsynth.score.Column;
import com.softsynth.score.JSynScoreClock;
import com.softsynth.score.ScoreNote;
import com.softsynth.score.ScorePlayer;
import com.softsynth.score.Sequence;

public class PlaySimpleScore {
    private static final int MAX_VOICES = 8;
    private Synthesizer synth;
    private VoiceAllocator allocator;
    private LineOut lineOut;
    private double advance = 0.2;
    private SubtractiveSynthVoice[] voices;

    private void test() throws InterruptedException {
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.voices = new SubtractiveSynthVoice[8];
        int i = 0;
        while (i < 8) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            voice.getOutput().connect(0, this.lineOut.input, 0);
            voice.getOutput().connect(0, this.lineOut.input, 1);
            this.voices[i] = voice;
            ++i;
        }
        this.allocator = new VoiceAllocator(this.voices);
        this.synth.start();
        this.lineOut.start();
        JSynScoreClock clock = new JSynScoreClock(this.synth);
        ScorePlayer scorePlayer = new ScorePlayer(clock);
        scorePlayer.setAdvance(this.advance);
        Sequence sequence = new Sequence();
        BasicScoreInstrument instrument = new BasicScoreInstrument(clock, this.allocator);
        sequence.setInstrument(instrument);
        double duration = 0.25;
        Column chord = new Column();
        chord.add(new ScoreNote(duration, 60.0));
        chord.add(new ScoreNote(duration, 64.0));
        chord.add(new ScoreNote(duration, 65.0));
        int i2 = 0;
        while (i2 < 4) {
            sequence.add(chord);
            sequence.add(new ScoreNote(duration, 72.0));
            sequence.add(new ScoreNote(duration, 67.0));
            sequence.add(new ScoreNote(duration, 64.0));
            ++i2;
        }
        double timeNow = clock.getScoreTime();
        scorePlayer.play(sequence, timeNow + this.advance);
        this.synth.sleepFor(1.0);
        this.synth.stop();
    }

    public static void main(String[] args) {
        try {
            new PlaySimpleScore().test();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

