/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.shared.time;

import com.softsynth.shared.time.ScheduledQueue;
import com.softsynth.shared.time.TimeStamp;
import junit.framework.TestCase;

public class TestScheduledQueue
extends TestCase {
    public void testOneEntry() {
        ScheduledQueue<String> sq = new ScheduledQueue<String>();
        TestScheduledQueue.assertTrue("Initially empty.", sq.isEmpty());
        TimeStamp early = new TimeStamp(1.2);
        TimeStamp time1 = new TimeStamp(1.4);
        sq.add(time1, "Hello");
        String s1 = (String)sq.removeNext(early);
        TestScheduledQueue.assertEquals("Should get null cuz too early.", null, s1);
        s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get Hello cuz on time.", "Hello", s1);
        s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get null cuz empty.", null, s1);
    }

    public void testSimultaneousOrder() {
        ScheduledQueue<String> sq = new ScheduledQueue<String>();
        TimeStamp time1 = new TimeStamp(1.4);
        sq.add(time1, "Hello");
        sq.add(time1, "Fred");
        sq.add(time1, "Bye");
        String s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get Hello cuz on time.", "Hello", s1);
        s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get Fred", "Fred", s1);
        s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get Bye", "Bye", s1);
        s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get null cuz empty.", null, s1);
    }

    public void testMixedOrder() {
        ScheduledQueue<String> sq = new ScheduledQueue<String>();
        TimeStamp time1 = new TimeStamp(1.4);
        TimeStamp time2 = new TimeStamp(23.7);
        sq.add(time1, "Hello");
        sq.add(time2, "Ola");
        sq.add(time1, "Fred");
        sq.add(time2, "Jose");
        sq.add(time1, "Bye");
        sq.add(time2, "Adios");
        String s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get Hello cuz on time.", "Hello", s1);
        s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get Fred", "Fred", s1);
        s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get Bye", "Bye", s1);
        s1 = (String)sq.removeNext(time1);
        TestScheduledQueue.assertEquals("Should get null cuz empty.", null, s1);
        s1 = (String)sq.removeNext(time2);
        TestScheduledQueue.assertEquals("Should get Ola cuz on time.", "Ola", s1);
        s1 = (String)sq.removeNext(time2);
        TestScheduledQueue.assertEquals("Should get Jose", "Jose", s1);
        s1 = (String)sq.removeNext(time2);
        TestScheduledQueue.assertEquals("Should get Adios", "Adios", s1);
        s1 = (String)sq.removeNext(time2);
        TestScheduledQueue.assertEquals("Should get null cuz empty.", null, s1);
    }

    public void testRandomInOut() {
        ScheduledQueue<String> sq = new ScheduledQueue<String>();
        double now = 5.0;
        double MAX_FUTURE = 20.0;
        double MAX_TIME_TO_ADD = 50.0;
        int numAdded = 0;
        int numRemoved = 0;
        while (now <= 70.0) {
            if (now <= 50.0) {
                double t = Math.random() * 20.0 + now;
                TimeStamp future = new TimeStamp(t);
                String st = "" + t;
                sq.add(future, st);
                ++numAdded;
            }
            String s2 = null;
            do {
                TimeStamp wtNow;
                if ((s2 = (String)sq.removeNext(wtNow = new TimeStamp(now))) == null) continue;
                double timeFromQueue = Double.parseDouble(s2);
                TestScheduledQueue.assertTrue("timeFromQueue should be sequential", timeFromQueue <= now);
                ++numRemoved;
            } while (s2 != null);
            now += 0.1;
        }
    }
}

