/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.XMLListener;
import com.softsynth.util.XMLTools;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.StreamCorruptedException;
import java.util.Hashtable;

public class XMLReader
extends PushbackInputStream {
    XMLListener listener;
    static final int IDLE = 0;
    static final int INTAG = 0;
    static int depth = 0;
    static final int STATE_TOP = 0;
    static final int STATE_TAG_NAME = 1;
    static final int STATE_TAG_FIND_ANGLE = 2;
    static final int STATE_TAG_ATTR_NAME = 3;
    static final int STATE_TAG_FIND_EQUAL = 4;
    static final int STATE_TAG_FIND_QUOTE = 5;
    static final int STATE_TAG_ATTR_VALUE = 6;
    static final int STATE_CONTENT = 7;
    static final int STATE_CHECK_END = 8;
    static final int STATE_TAG_SKIP = 9;

    public void setXMLListener(XMLListener listener) {
        this.listener = listener;
    }

    public XMLReader(InputStream stream) {
        super(stream);
    }

    private int readChar() throws IOException {
        int c = this.read();
        if (c < 0) {
            return c;
        }
        if (c < 128) {
            return c;
        }
        byte[] bar = null;
        if (c < 224) {
            bar = new byte[2];
        } else if (c < 240) {
            bar = new byte[3];
        } else if (c < 248) {
            bar = new byte[4];
        } else if (c < 252) {
            bar = new byte[5];
        } else if (c < 254) {
            bar = new byte[6];
        }
        bar[0] = (byte)c;
        int i = 1;
        while (i < bar.length) {
            c = this.read();
            if ((c & 0xC0) != 128) {
                throw new IOException("invalid UTF8 continuation " + Integer.toHexString(c));
            }
            bar[i] = (byte)c;
            ++i;
        }
        return new String(bar, "UTF8").charAt(0);
    }

    public void parse() throws IOException {
        int i;
        while ((i = this.readChar()) >= 0) {
            char c = (char)i;
            if (c == '<') {
                this.parseElement();
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new StreamCorruptedException("Unexpected character. This doesn't look like an XML file!");
        }
    }

    String charToString(char c) {
        String s;
        switch (c) {
            case '\r': {
                s = "\\r";
                break;
            }
            case '\n': {
                s = "\\n";
                break;
            }
            case '\t': {
                s = "\\t";
                break;
            }
            default: {
                s = Character.isWhitespace(c) ? " " : "" + c;
            }
        }
        return s;
    }

    boolean isStringWhite(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void parseElement() throws IOException {
        int state = 1;
        String tagName = "";
        String name = null;
        String value = null;
        boolean ifEmpty = false;
        boolean endTag = false;
        boolean done = false;
        boolean skipWhiteSpace = true;
        char endQuote = '\"';
        String content = null;
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        while (!done) {
            char c;
            do {
                int i;
                if ((i = this.readChar()) < 0) {
                    throw new EOFException("EOF inside element!");
                }
                c = (char)i;
            } while (skipWhiteSpace && Character.isWhitespace(c));
            skipWhiteSpace = false;
            switch (state) {
                case 1: {
                    if (Character.isWhitespace(c)) {
                        skipWhiteSpace = true;
                        state = 2;
                        break;
                    }
                    if (c == '/') {
                        ifEmpty = true;
                        state = 2;
                        break;
                    }
                    if (c == '>') {
                        if (endTag) {
                            this.listener.endElement(tagName);
                            done = true;
                            break;
                        }
                        this.listener.beginElement(tagName, attributes, ifEmpty);
                        state = 7;
                        break;
                    }
                    if (c == '?') {
                        state = 9;
                        break;
                    }
                    if (c == '!') {
                        state = 9;
                        break;
                    }
                    tagName = String.valueOf(tagName) + c;
                    break;
                }
                case 9: {
                    if (c != '>') break;
                    done = true;
                    break;
                }
                case 2: {
                    if (c == '/') {
                        ifEmpty = true;
                        break;
                    }
                    if (c == '>') {
                        if (endTag) {
                            this.listener.endElement(tagName);
                            done = true;
                            break;
                        }
                        this.listener.beginElement(tagName, attributes, ifEmpty);
                        state = 7;
                        done = ifEmpty;
                        break;
                    }
                    state = 3;
                    name = "" + c;
                    break;
                }
                case 3: {
                    if (Character.isWhitespace(c)) {
                        skipWhiteSpace = true;
                        state = 4;
                        break;
                    }
                    if (c == '=') {
                        skipWhiteSpace = true;
                        state = 5;
                        break;
                    }
                    name = String.valueOf(name) + c;
                    break;
                }
                case 4: {
                    if (c == '=') {
                        skipWhiteSpace = true;
                        state = 5;
                        break;
                    }
                    throw new StreamCorruptedException("Found " + this.charToString(c) + ", expected =.");
                }
                case 5: {
                    if (c == '\"') {
                        state = 6;
                        value = "";
                        endQuote = '\"';
                        break;
                    }
                    if (c == '\'') {
                        state = 6;
                        value = "";
                        endQuote = '\'';
                        break;
                    }
                    throw new StreamCorruptedException("Found " + this.charToString(c) + ", expected '\"'.");
                }
                case 6: {
                    if (c == endQuote) {
                        attributes.put(name, value);
                        skipWhiteSpace = true;
                        state = 2;
                        break;
                    }
                    value = String.valueOf(value) + c;
                    break;
                }
                case 7: {
                    if (c == '<') {
                        state = 8;
                        if (!this.isStringWhite(content)) {
                            String unescaped = XMLTools.unescapeText(content);
                            this.listener.foundContent(unescaped);
                        }
                        content = null;
                        break;
                    }
                    if (content == null) {
                        content = "";
                    }
                    content = String.valueOf(content) + c;
                    break;
                }
                case 8: {
                    if (c == '/') {
                        endTag = true;
                        state = 1;
                        tagName = "";
                        break;
                    }
                    this.unread(c);
                    this.parseElement();
                    state = 7;
                }
            }
        }
    }

    public static int getAttribute(Hashtable attributes, String key, int defaultValue) {
        String s = (String)attributes.get(key);
        return s == null ? defaultValue : Integer.parseInt(s);
    }

    public static double getAttribute(Hashtable attributes, String key, double defaultValue) {
        String s = (String)attributes.get(key);
        return s == null ? defaultValue : Double.valueOf(s);
    }
}

