/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.EnvelopePoints;
import com.softsynth.wire.EnvelopeModule;
import com.softsynth.wire.LoaderContext;
import com.softsynth.wire.Module;
import com.softsynth.wire.ModuleLoader;
import com.softsynth.wire.Patch;
import java.util.Hashtable;

class EnvelopeLoader
extends ModuleLoader {
    boolean autoStop;
    EnvelopePoints points = new EnvelopePoints();

    public EnvelopeLoader(String tag, LoaderContext ldcon) {
        super(tag, ldcon);
    }

    void handleFlagsAttributes(Hashtable attributes) {
        this.autoStop = this.getAttribute(attributes, "autostop", 0) != 0;
    }

    void handleFrameAttributes(Hashtable attributes) {
        double duration = this.getAttribute(attributes, "dur", 0.0);
        double value = this.getAttribute(attributes, "value", 0.0);
        this.points.add(duration, value);
    }

    void handleSustainAttributes(Hashtable attributes) {
        int begin = this.getAttribute(attributes, "begin", -1);
        int end = this.getAttribute(attributes, "end", -1);
        this.points.setSustainLoop(begin, end);
    }

    void handleReleaseAttributes(Hashtable attributes) {
        int begin = this.getAttribute(attributes, "begin", -1);
        int end = this.getAttribute(attributes, "end", -1);
        this.points.setReleaseLoop(begin, end);
    }

    @Override
    public void handleBeginElement(String tag, Hashtable attributes) {
        if (tag.equals("frame")) {
            this.handleFrameAttributes(attributes);
        } else if (tag.equals("sustain")) {
            this.handleSustainAttributes(attributes);
        } else if (tag.equals("release")) {
            this.handleReleaseAttributes(attributes);
        } else if (tag.equals("flags")) {
            this.handleFlagsAttributes(attributes);
        } else {
            super.handleBeginElement(tag, attributes);
        }
    }

    @Override
    public void handleEndElement() {
        this.setupModule(this.patch);
        super.handleEndElement();
    }

    @Override
    Module makeModule(Patch patch) {
        EnvelopeModule envelopeModule = new EnvelopeModule(this.points);
        envelopeModule.setup(patch, this.name, "Envelope");
        patch.addModule(envelopeModule);
        envelopeModule.setAutoStop(this.autoStop);
        return envelopeModule;
    }
}

