/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.wire.Module;
import com.softsynth.wire.Patch;
import com.softsynth.wire.Patchable;
import com.softsynth.wire.RubberBand;
import com.softsynth.wire.WireJack;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

class PatchPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    Patch patch;
    RubberBand rubberBand;
    int startX;
    int startY;
    int offsetX;
    int offsetY;
    WireJack target = null;
    WireJack source = null;
    static final int DRAG_IDLE = 0;
    static final int DRAG_RECT = 1;
    static final int DRAG_LINE = 2;
    static final int DRAG_SELECT = 3;
    int dragState = 0;
    Rectangle draggingRect = null;
    Rectangle tempPanelRect = null;

    public PatchPanel(Patch patch) {
        this.patch = patch;
        this.setLayout(null);
        this.rubberBand = new RubberBand();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public static Frame getFrame(Component comp) {
        int countdown = 10;
        Container parent = comp.getParent();
        do {
            if (parent instanceof Frame) {
                return (Frame)parent;
            }
            parent = parent.getParent();
        } while (countdown-- > 0);
        throw new RuntimeException("Could not find parent Frame.");
    }

    public Frame getFrame() {
        return PatchPanel.getFrame(this);
    }

    String getTagName() {
        return "patch";
    }

    void startDragSelecting(MouseEvent e) {
        if (!e.isShiftDown()) {
            this.patch.deselectAll();
        }
        this.startX = e.getX();
        this.startY = e.getY();
        this.rubberBand.startRectangle(this.startX, this.startY, 1, 1);
        this.dragState = 3;
    }

    Rectangle getSelectedBounds() {
        return this.getGroupBounds(this.patch.selected);
    }

    Rectangle getPatchBounds() {
        return this.getGroupBounds(this.patch.modules);
    }

    Rectangle getGroupBounds(Vector group) {
        Rectangle rect = null;
        Enumeration enumer = group.elements();
        while (enumer.hasMoreElements()) {
            Module module = (Module)enumer.nextElement();
            if (rect == null) {
                rect = module.getPanel().getBounds();
                continue;
            }
            Rectangle modRect = module.getPanel().getBounds();
            rect = rect.union(modRect);
        }
        return rect;
    }

    void startDragging(MouseEvent e) {
        Patchable pc = (Patchable)((Object)e.getComponent());
        WireJack wjack = pc.getWireJack();
        Module module = wjack.getModule();
        if (e.isShiftDown()) {
            if (module.getSelected()) {
                this.patch.deselectModule(module);
                return;
            }
            this.patch.selectModule(module);
        } else if (!module.getSelected()) {
            this.patch.deselectAll();
            this.patch.selectModule(module);
        }
        this.tempPanelRect = this.getBounds();
        this.draggingRect = this.getSelectedBounds();
        if (this.draggingRect == null) {
            return;
        }
        this.offsetX = e.getX() - this.draggingRect.x;
        this.offsetY = e.getY() - this.draggingRect.y;
        this.rubberBand.startMovingRectangle(this.getGraphics(), this.draggingRect.x, this.draggingRect.y, this.draggingRect.width, this.draggingRect.height);
        this.dragState = 1;
    }

    void startConnecting(Component sourceComp, Component trackingComp) {
        Point pnt = trackingComp.getLocationOnScreen();
        Point refLoc = this.getLocationOnScreen();
        this.startX = pnt.x - refLoc.x;
        this.startY = pnt.y - refLoc.y;
        this.source = ((Patchable)((Object)sourceComp)).getWireJack();
        Point tie = this.source.getTiePoint(this.getLocationOnScreen(), 1);
        this.rubberBand.startLine(tie.x, tie.y);
        this.dragState = 2;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == '\u007f' || key == '\b') {
            this.patch.deleteSelected();
            this.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        switch (this.dragState) {
            case 1: {
                this.continueDragging(e.getX(), e.getY());
                break;
            }
            case 2: {
                this.rubberBand.drawLine(this.getGraphics(), this.startX + e.getX(), this.startY + e.getY());
                break;
            }
            case 3: {
                this.rubberBand.dragRectangle(this.getGraphics(), e.getX(), e.getY());
            }
        }
    }

    void finishDragSelecting(MouseEvent e) {
        int temp;
        int xpos = e.getX();
        int ypos = e.getY();
        if (xpos < this.startX) {
            temp = xpos;
            xpos = this.startX;
            this.startX = temp;
        }
        if (ypos < this.startY) {
            temp = ypos;
            ypos = this.startY;
            this.startY = temp;
        }
        int width = xpos - this.startX;
        int height = ypos - this.startY;
        if (width > 1 && height > 1) {
            Rectangle rect = new Rectangle(this.startX, this.startY, width, height);
            this.patch.selectBoundedModules(rect);
        }
        this.repaint();
    }

    private void updatePanelSize() {
        int maxX = 50;
        int maxY = 50;
        Enumeration enumer = this.patch.modules.elements();
        while (enumer.hasMoreElements()) {
            Module module = (Module)enumer.nextElement();
            Point modLoc = module.getPanel().getLocation();
            int farX = modLoc.x + module.getPanel().getWidth();
            int farY = modLoc.y + module.getPanel().getHeight();
            if (farX > maxX) {
                maxX = farX;
            }
            if (farY <= maxY) continue;
            maxY = farY;
        }
        this.setMinimumSize(new Dimension(maxX += 11, maxY += 12));
        this.setPreferredSize(new Dimension(maxX, maxY));
    }

    void shiftSelectedModules(int deltaX, int deltaY) {
        Enumeration enumer = this.patch.selected.elements();
        while (enumer.hasMoreElements()) {
            Module module = (Module)enumer.nextElement();
            Point modLoc = module.getPanel().getLocation();
            module.getPanel().setLocation(modLoc.x + deltaX, modLoc.y + deltaY);
        }
    }

    int clipDraggedX(int mouseX) {
        int x = mouseX - this.offsetX;
        if (x < 0) {
            x = 0;
        } else if (x + this.draggingRect.width > this.tempPanelRect.width) {
            x = this.tempPanelRect.width - this.draggingRect.width;
        }
        return x;
    }

    int clipDraggedY(int mouseY) {
        int y = mouseY - this.offsetY;
        if (y < 0) {
            y = 0;
        } else if (y + this.draggingRect.height > this.tempPanelRect.height) {
            y = this.tempPanelRect.height - this.draggingRect.height;
        }
        return y;
    }

    void continueDragging(int xpos, int ypos) {
        if (this.draggingRect != null) {
            int x = this.clipDraggedX(xpos);
            int y = this.clipDraggedY(ypos);
            this.rubberBand.moveRectangle(this.getGraphics(), x, y);
        }
    }

    void finishDragging(int xpos, int ypos) {
        this.rubberBand.endRectangle(this.getGraphics());
        if (this.draggingRect != null) {
            int x = this.clipDraggedX(xpos);
            int y = this.clipDraggedY(ypos);
            int deltaX = x - this.draggingRect.x;
            int deltaY = y - this.draggingRect.y;
            if (deltaX != 0 || deltaY != 0) {
                this.shiftSelectedModules(deltaX, deltaY);
                this.updatePanelSize();
                this.patch.setModified(true);
                this.repaint();
            }
            this.draggingRect = null;
        }
    }

    void finishConnecting() {
        this.rubberBand.endLine(this.getGraphics());
        if (this.target != null) {
            this.source.connect(this.target);
            this.target.setHighlighted(false);
            this.repaint();
        }
        this.target = null;
        this.source = null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            Component comp = e.getComponent();
            if (comp != this) {
                Patchable pc = (Patchable)((Object)comp);
                WireJack wjack = pc.getWireJack();
                wjack.edit();
            }
        } else {
            this.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.source = null;
        Component comp = e.getComponent();
        if (comp == this) {
            this.startDragSelecting(e);
        } else {
            int num;
            Patchable pc = (Patchable)((Object)comp);
            WireJack wjack = pc.getWireJack();
            if (wjack.getDragged() != null) {
                this.startDragging(e);
            } else if (wjack.isOutput()) {
                this.startConnecting(e.getComponent(), e.getComponent());
            } else if (!wjack.isOutput() && (num = wjack.getConnectedCount()) > 0) {
                WireJack other = wjack.getConnected(num - 1);
                wjack.disconnect(other);
                int w = this.getWidth();
                int h = this.getHeight();
                this.getGraphics().clearRect(0, 0, w, h);
                this.paint(this.getGraphics());
                this.startConnecting(other.getComponent(), e.getComponent());
                this.target = wjack;
                wjack.setHighlighted(true);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        switch (this.dragState) {
            case 1: {
                this.finishDragging(e.getX(), e.getY());
                break;
            }
            case 2: {
                this.finishConnecting();
                break;
            }
            case 3: {
                this.finishDragSelecting(e);
            }
        }
        this.dragState = 0;
        this.requestFocus();
        this.getFrame().repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Component comp = e.getComponent();
        if (comp instanceof Patchable) {
            Module module;
            Patchable pc = (Patchable)((Object)comp);
            WireJack pt = pc.getWireJack();
            if (comp != this && this.source != null) {
                int targetMask = pt.getSupportMask();
                int sourceMask = this.source.getSupportMask();
                if (!pt.isOutput() && (targetMask & sourceMask) != 0) {
                    this.target = pt;
                    pt.setHighlighted(true);
                }
            }
            if ((module = pt.getModule()) != null) {
                String text = String.valueOf(module.getName()) + "." + pt.getName();
                this.patch.showFaderValue(text, pt.get());
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.target != null) {
            this.target.setHighlighted(false);
        }
        this.target = null;
    }

    public void addModule(Module module) {
        this.add((Component)module.getPanel(), 0);
        this.updatePanelSize();
        this.refreshDisplay();
    }

    private void refreshDisplay() {
        this.validate();
        this.repaint();
    }
}

