/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.util.NumericOutput;
import com.softsynth.util.TextOutput;
import com.softsynth.wire.LabelledTextField;
import com.softsynth.wire.SampleModule;
import com.softsynth.wire.Wire;
import com.softsynth.wire.WireUpdater;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class SampleUpdater
extends JPanel
implements WireUpdater {
    SampleModule module;
    JTextField nameField;
    JButton browseButton;
    JRadioButton fromFileBox;
    JRadioButton emptyBox;
    JCheckBox autoStopBox;
    JRadioButton monoBox;
    JRadioButton stereoBox;
    LabelledTextField emptySizeField;
    LabelledTextField baseNoteField;
    private JButton saveButton;

    public SampleUpdater(SampleModule sModule) {
        this.module = sModule;
        this.setLayout(new GridLayout(0, 1));
        ButtonGroup cbg = new ButtonGroup();
        Panel namePanel = new Panel();
        this.add(namePanel);
        this.fromFileBox = new JRadioButton("fromFile", true);
        cbg.add(this.fromFileBox);
        this.fromFileBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SampleUpdater.this.setEnables();
            }
        });
        namePanel.add(this.fromFileBox);
        this.nameField = new JTextField("", 50);
        namePanel.add(this.nameField);
        this.browseButton = new JButton("Browse...");
        namePanel.add(this.browseButton);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File temp = Wire.browseLoad(SampleUpdater.this.module.getFile());
                if (temp != null) {
                    SampleUpdater.this.nameField.setText(temp.getPath());
                }
            }
        });
        JPanel emptyPanel = new JPanel();
        this.add(emptyPanel);
        this.emptyBox = new JRadioButton("empty", true);
        cbg.add(this.emptyBox);
        this.emptyBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SampleUpdater.this.setEnables();
            }
        });
        emptyPanel.add(this.emptyBox);
        this.emptySizeField = new LabelledTextField("Size(frames):", "12345", 10);
        emptyPanel.add(this.emptySizeField);
        ButtonGroup cbgChannels = new ButtonGroup();
        this.monoBox = new JRadioButton("mono", true);
        cbgChannels.add(this.monoBox);
        emptyPanel.add(this.monoBox);
        this.stereoBox = new JRadioButton("stereo", true);
        cbgChannels.add(this.stereoBox);
        emptyPanel.add(this.stereoBox);
        Panel tuningPanel = new Panel();
        this.add(tuningPanel);
        this.baseNoteField = new LabelledTextField("Base Pitch (60.0 is Middle C):", "60.00", 5);
        tuningPanel.add(this.baseNoteField);
        this.saveButton = new JButton("SaveToFile");
        tuningPanel.add(this.saveButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SampleUpdater.this.module.saveToFile();
            }
        });
        this.setEnables();
    }

    void setEnables() {
        this.nameField.setEnabled(this.fromFileBox.isSelected());
        this.browseButton.setEnabled(this.fromFileBox.isSelected());
        this.emptySizeField.setEnabled(this.emptyBox.isSelected());
        this.monoBox.setEnabled(this.emptyBox.isSelected());
        this.stereoBox.setEnabled(this.emptyBox.isSelected());
    }

    @Override
    public void update() {
        double baseFreq;
        File tempFile = this.module.getFile();
        TextOutput.println("SampleUpdater.update: file = " + tempFile);
        if (tempFile == null) {
            this.nameField.setText("");
        } else {
            this.fromFileBox.setSelected(true);
            this.nameField.setText(tempFile.getPath());
        }
        SynthSample samp = this.module.getSample();
        if (samp != null) {
            this.emptySizeField.textField.setText("" + samp.getNumFrames());
            this.monoBox.setSelected(samp.getChannelsPerFrame() == 1);
            baseFreq = samp.getBaseFrequency();
        } else {
            this.emptySizeField.textField.setText("1000");
            this.monoBox.setSelected(true);
            baseFreq = 440.0;
        }
        double basePitch = EqualTemperedTuning.getMIDIPitch(baseFreq);
        String pitchString = NumericOutput.doubleToString(basePitch, 5, 2);
        this.baseNoteField.textField.setText(pitchString);
        this.setEnables();
    }

    @Override
    public boolean applyEdit() {
        boolean result = false;
        if (this.fromFileBox.isSelected()) {
            result = this.module.loadFromFile(new File(this.nameField.getText()));
            if (result) {
                return result;
            }
        } else if (this.emptyBox.isSelected()) {
            int numChannels;
            int numFrames = this.emptySizeField.getInteger();
            int n = numChannels = this.monoBox.isSelected() ? 1 : 2;
            if (this.module.getSample() == null || numFrames != this.module.getSample().getNumFrames() || numChannels != this.module.getSample().getChannelsPerFrame()) {
                this.module.remakeSample(numFrames, numChannels);
            }
        }
        try {
            double basePitch = this.baseNoteField.getDouble();
            double baseFreq = EqualTemperedTuning.getMIDIFrequency(basePitch);
            this.module.getSample().setBaseFrequency(baseFreq);
            this.module.update();
        }
        catch (NumberFormatException e) {
            this.baseNoteField.textField.setText("Error!");
            this.baseNoteField.textField.selectAll();
            result = true;
        }
        this.module.getPatch().setModified(true);
        return result;
    }
}

