/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.Synth;

public class SynthClock {
    int initialTicks = 0;
    int lastTicks = this.initialTicks = this.getNativeTicks();
    double lastTime = 0.0;
    double advanceTime = 0.0;
    private double ticksPerSecond = Synth.getTickRate();
    private double secondsPerTick = 1.0 / this.ticksPerSecond;

    int getNativeTicks() {
        return Synth.getTickCount();
    }

    public void sleepUntilNative(int wakeupTicks) throws InterruptedException {
        Synth.sleepUntilTick(wakeupTicks);
    }

    synchronized void updateTime() {
        int currentTicks = this.getNativeTicks();
        this.lastTime += (double)(currentTicks - this.lastTicks) * this.secondsPerTick;
        this.lastTicks = currentTicks;
    }

    public double realTime() {
        this.updateTime();
        return this.lastTime;
    }

    public synchronized double now() {
        return this.realTime() + this.advanceTime;
    }

    public void setAdvance(double duration) {
        this.advanceTime = duration;
    }

    public double getAdvance() {
        return this.advanceTime;
    }

    public int timeToNative(double time) {
        return (int)((time - this.lastTime) * this.ticksPerSecond) + this.lastTicks;
    }

    public void sleepUntil(double time) throws InterruptedException {
        this.sleepUntilNative(this.timeToNative(time - this.advanceTime));
    }
}

