/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.LabelledWireJack;
import com.softsynth.wire.Module;
import com.softsynth.wire.Patch;
import com.softsynth.wire.UnitModule;
import com.softsynth.wire.Wire;
import com.softsynth.wire.WireJack;
import com.softsynth.wire.engine.WireMessage;
import java.io.IOException;

class SynthWireJack
extends LabelledWireJack {
    SynthPort port;

    public SynthWireJack(Module module, String name, SynthPort port) {
        super(module, name);
        this.port = port;
    }

    String getSourceName() {
        return String.valueOf(this.getModule().getName()) + "." + this.getName();
    }

    public SynthPort getSynthPort() {
        return this.port;
    }

    public void setSynthPort(SynthPort port) {
        this.port = port;
    }

    @Override
    public double get() {
        double val = 0.0;
        val = this.port == null ? super.get() : (this.port instanceof SynthDistributor ? ((SynthDistributor)this.port).get() : (this.port instanceof SynthVariable ? ((SynthVariable)this.port).getCurrent() : super.get()));
        return val;
    }

    @Override
    public void set(double value) {
        super.set(value);
        if (this.port != null) {
            ((SynthVariable)this.port).set(value);
        }
    }

    public void set(double time, double value) {
        super.set(value);
        int ticks = Wire.clock.timeToNative(time);
        if (this.port != null) {
            ((SynthVariable)this.port).set(ticks, value);
        }
    }

    @Override
    void message(WireMessage msg) {
        this.set(msg.getTimeStamp(), msg.getValue());
    }

    @Override
    public void setMin(double min) {
        super.setMin(min);
        if (this.port != null) {
            ((SynthVariable)this.port).setMin(min);
        }
    }

    @Override
    public void setMax(double max) {
        super.setMax(max);
        if (this.port != null) {
            ((SynthVariable)this.port).setMax(max);
        }
    }

    public void generateConnectionSource(IndentingWriter writer) throws IOException {
        int i = 0;
        while (i < this.getConnectedCount()) {
            SynthWireJack connected = (SynthWireJack)this.getConnected(i);
            Module connectedModule = connected.getModule();
            if (connectedModule instanceof UnitModule || connectedModule instanceof Patch) {
                int srcPartNum = this.getPartIndex();
                int destPartNum = connected.getPartIndex();
                if (srcPartNum == 0 && destPartNum == 0) {
                    writer.println(String.valueOf(this.getSourceName()) + ".connect( " + connected.getSourceName() + ");");
                } else {
                    writer.println(String.valueOf(this.getSourceName()) + ".connect( " + srcPartNum + ", " + connected.getSourceName() + ", " + destPartNum + ");");
                }
            }
            ++i;
        }
    }

    public void matchOther(WireJack other) {
        this.setSupportMask(other.getSupportMask());
        this.comp.setBackground(other.getComponent().getBackground());
        this.comp.repaint();
    }
}

