/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.TextOutput;
import com.softsynth.util.XMLListener;
import com.softsynth.util.XMLReader;
import com.softsynth.wire.LoaderContext;
import com.softsynth.wire.ModuleGroupLoader;
import com.softsynth.wire.Patch;
import com.softsynth.wire.RecursiveLoader;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

class TopLoader
extends RecursiveLoader
implements XMLListener {
    boolean insideWiredoc = false;
    LoaderContext ldcon;

    public TopLoader(Patch patch) {
        this(patch, false);
    }

    public TopLoader(Patch patch, boolean selectWhenLoaded) {
        this.ldcon = new LoaderContext(patch);
        this.ldcon.selectWhenLoaded = selectWhenLoaded;
    }

    @Override
    public void handleBeginElement(String tag, Hashtable attributes) {
        if (tag.equals("wiredoc")) {
            this.insideWiredoc = true;
            this.ldcon.version = this.getAttribute(attributes, "version", 0.0);
            if (this.ldcon.version > 1.3) {
                TextOutput.println("Patch file was created by a later version, " + this.ldcon.version + " of Wire.");
                TextOutput.println("Please upgrade your copy of Wire!");
            }
        } else if (this.insideWiredoc) {
            if (tag.equals("patch") && this.ldcon.version <= 0.8 || tag.equals("group")) {
                ModuleGroupLoader loader = new ModuleGroupLoader(tag, this.ldcon);
                this.subLoader = loader;
                Rectangle rect = this.subLoader.handleEditorAttributes(attributes);
                if (rect != null) {
                    this.ldcon.patch.setEditorBounds(rect);
                }
            } else {
                TextOutput.println("Unrecognized element in wiredoc = " + tag);
            }
        } else {
            super.handleBeginElement(tag, attributes);
        }
    }

    public boolean load(InputStream stream) {
        boolean result = true;
        try {
            XMLReader xmlr = new XMLReader(stream);
            xmlr.setXMLListener(this);
            xmlr.parse();
            xmlr.close();
            result = false;
        }
        catch (IOException e) {
            TextOutput.println("TopLoader Error = " + e);
        }
        catch (SecurityException e) {
            TextOutput.println("TopLoader Error = " + e);
        }
        return result;
    }
}

