/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.SynthPort;
import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.ExternalPortModule;
import com.softsynth.wire.SaveAsStream;
import com.softsynth.wire.SynthWireJack;
import com.softsynth.wire.Wire;
import com.softsynth.wire.WireJack;
import com.softsynth.wire.WireNameRangeEditor;
import java.io.IOException;

class VariableOrInputPort
extends ExternalPortModule {
    @Override
    WireJack getJack(String name, int partIndex) {
        return super.getJack("output", partIndex);
    }

    @Override
    boolean edit() {
        WireNameRangeEditor editor = new WireNameRangeEditor(this.patch.getPatchPanel().getFrame(), this, this.portJack);
        if (this.editorBounds != null) {
            editor.setBounds(this.editorBounds);
        }
        boolean result = editor.ask() == 1;
        this.editorBounds = editor.getBounds();
        return result;
    }

    @Override
    public void generateSource(IndentingWriter writer, int phase) throws IOException {
        int numConnected = this.portJack.getConnectedCount();
        if (numConnected == 0) {
            return;
        }
        String name = this.getName();
        switch (phase) {
            case 0: {
                if (name.equals("frequency") || name.equals("amplitude")) break;
                if (numConnected > 1) {
                    writer.println("public SynthDistributor " + name + ";");
                    break;
                }
                SynthWireJack swPort = (SynthWireJack)this.portJack.getConnected(0);
                SynthPort sPort = swPort.getSynthPort();
                String className = Wire.stripJSynPackage(sPort.getClass().getName());
                writer.println("public " + className + " " + name + ";");
                break;
            }
            case 1: {
                if (numConnected <= 1) break;
                writer.println(String.valueOf(name) + " = new SynthDistributor( this, \"" + name + "\" );");
                break;
            }
            case 2: {
                if (numConnected > 1) {
                    this.portJack.generateConnectionSource(writer);
                } else {
                    SynthWireJack other = (SynthWireJack)this.portJack.getConnected(0);
                    writer.println();
                    writer.println("addPort( " + name + " = " + other.getSourceName() + ", \"" + name + "\" );");
                }
                if ((this.portJack.getSupportMask() & 1) == 0) break;
                writer.println(String.valueOf(name) + ".setup( " + this.portJack.getMin() + ", " + this.portJack.get() + ", " + this.portJack.getMax() + " );");
            }
        }
    }

    @Override
    void saveContentToStream(SaveAsStream stream) throws IOException {
        super.saveContentToStream(stream);
        if ((this.portJack.getSupportMask() & 1) != 0) {
            stream.writePortValue("min", this.portJack.getName(), this.portJack.getMin());
            stream.writePortValue("max", this.portJack.getName(), this.portJack.getMax());
            stream.writePortValue("set", this.portJack.getName(), this.portJack.get());
        }
    }
}

