/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.apps;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.util.VoiceAllocator;
import com.jsyn.util.WaveRecorder;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.score.JSynScoreClock;
import com.softsynth.score.Score;
import com.softsynth.score.ScoreClock;
import com.softsynth.score.ScoreInstrument;
import com.softsynth.score.ScorePlayer;
import com.softsynth.score.ScoreThread;
import com.syntona.gui.EasyFileChooser;
import com.syntona.model.music.DynamicIntonationEditor;
import com.syntona.model.music.DynamicNote;
import com.syntona.model.music.DynamicScoreInstrument;
import com.syntona.model.music.DynamicTrack;
import com.syntona.model.music.Intonation;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;

public class DynamicScoreApplet
extends JApplet {
    private static final long serialVersionUID = 6356019695587244862L;
    private static final String VERSION = "0.0.9";
    private static final String COPYRIGHT = "(C) 2011 Mobileer Inc - BETA - Do Not Distribute";
    private static final int MAX_VOICES = 12;
    private Synthesizer synth;
    private VoiceAllocator allocator;
    private LineOut lineOut;
    private static final double ADVANCE = 0.2;
    private ScoreInstrument instrument;
    private Score score;
    private DynamicIntonationEditor dynamicEditor;
    private DynamicTrack sequence;
    private ScorePlayer scorePlayer;
    private double timeScale = 0.5;
    private byte[] noteClipboard;
    private JFrame frame;
    private File lastFile;
    private JButton saveButton;
    private WaveRecorder recorder;
    private PassThrough leftPass;
    private PassThrough rightPass;
    private File lastRecordingFile;
    private JButton recordButton;
    private SubtractiveSynthVoice[] voices;
    private ScoreThread scoreThread;
    private ScoreClock clock;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.leftPass = new PassThrough();
        this.synth.add(this.leftPass);
        this.rightPass = new PassThrough();
        this.synth.add(this.rightPass);
        this.leftPass.getOutput().connect(0, this.lineOut.input, 0);
        this.rightPass.getOutput().connect(0, this.lineOut.input, 1);
        this.voices = new SubtractiveSynthVoice[12];
        int i = 0;
        while (i < 12) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            voice.getOutput().connect(this.leftPass);
            voice.getOutput().connect(this.rightPass);
            this.voices[i] = voice;
            ++i;
        }
        this.allocator = new VoiceAllocator(this.voices);
        this.clock = new JSynScoreClock(this.synth);
        this.instrument = new DynamicScoreInstrument(this.clock, this.allocator);
        this.scorePlayer = new ScorePlayer(new JSynScoreClock(this.synth));
        this.scorePlayer.setAdvance(0.2);
        this.score = new Score();
        this.sequence = new DynamicTrack();
        this.sequence.setInstrument(this.instrument);
        this.score.add(this.sequence);
        DynamicNote note = new DynamicNote(EqualTemperedTuning.getMIDIFrequency(60.0));
        this.sequence.add(note);
        note = new DynamicNote(note, 3, 2);
        this.sequence.add(note);
        note.setTime(1.0);
        note = new DynamicNote(note, 5, 4);
        this.sequence.add(note);
        note.setTime(2.0);
        note = new DynamicNote(note, 4, 5);
        this.sequence.add(note);
        note.setTime(2.0);
        note = new DynamicNote(note, 4, 5);
        this.sequence.add(note);
        note.setTime(2.0);
        this.sequence.sortByTime();
        this.setupGUI();
        Intonation.getInstance().print();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.dynamicEditor = new DynamicIntonationEditor(this.sequence);
        this.add("Center", this.dynamicEditor);
        JButton startButton = new JButton("Start");
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DynamicScoreApplet.this.startPlaying();
            }
        });
        this.dynamicEditor.addToToolbar(startButton);
        JButton stopButton = new JButton("Stop");
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DynamicScoreApplet.this.stopPlaying();
            }
        });
        this.dynamicEditor.addToToolbar(stopButton);
        JButton saveAsButton = new JButton("SaveAs...");
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DynamicScoreApplet.this.saveSequenceAs();
                DynamicScoreApplet.this.saveButton.setEnabled(true);
            }
        });
        this.dynamicEditor.addToToolbar(saveAsButton);
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DynamicScoreApplet.this.lastFile != null) {
                    DynamicScoreApplet.this.saveSequence(DynamicScoreApplet.this.lastFile);
                }
            }
        });
        this.dynamicEditor.addToToolbar(this.saveButton);
        this.saveButton.setEnabled(false);
        JButton loadButton = new JButton("Open");
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DynamicScoreApplet.this.loadSequence();
            }
        });
        this.dynamicEditor.addToToolbar(loadButton);
        JButton cutButton = new JButton("Cut");
        cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DynamicScoreApplet.this.cutNotes();
            }
        });
        this.dynamicEditor.addToToolbar(cutButton);
        JButton copyButton = new JButton("Copy");
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DynamicScoreApplet.this.copyNotes();
            }
        });
        this.dynamicEditor.addToToolbar(copyButton);
        JButton pasteButton = new JButton("Paste");
        pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DynamicScoreApplet.this.pasteNotes();
            }
        });
        this.dynamicEditor.addToToolbar(pasteButton);
        this.recordButton = new JButton("Record");
        this.recordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DynamicScoreApplet.this.recordScore();
            }
        });
        this.dynamicEditor.addToToolbar(this.recordButton);
        this.getParent().validate();
    }

    protected void recordScore() {
        File file = EasyFileChooser.chooseSaveFileAWT("Select a WAV file for the recording.", this.frame, this.lastRecordingFile, ".wav");
        if (file != null) {
            if (!file.getName().endsWith(".wav")) {
                file = new File(file.getParent(), String.valueOf(file.getName()) + ".wav");
            }
            this.lastRecordingFile = file;
            new Thread(){

                @Override
                public void run() {
                    DynamicScoreApplet.this.recordThreadRun();
                }
            }.start();
        }
    }

    protected void recordThreadRun() {
        this.recordButton.setEnabled(false);
        try {
            this.recorder = new WaveRecorder(this.synth, this.lastRecordingFile);
            System.out.println("Writing to WAV file " + this.lastRecordingFile.getAbsolutePath());
            this.leftPass.output.connect(0, this.recorder.getInput(), 0);
            this.rightPass.output.connect(0, this.recorder.getInput(), 1);
            this.recorder.start();
            double startTime = this.setupScorePlayer();
            this.scorePlayer.play(this.score, startTime);
            this.synth.sleepFor(2.0);
            this.recorder.stop();
            this.recorder.close();
            System.out.println("Finished recording.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.recordButton.setEnabled(true);
    }

    protected void pasteNotes() {
        if (this.noteClipboard != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.noteClipboard);
            XMLDecoder decoder = new XMLDecoder(inputStream);
            DynamicNote[] noteArray = (DynamicNote[])decoder.readObject();
            decoder.close();
            this.dynamicEditor.pasteNotes(noteArray);
        }
    }

    protected void copyNotes() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(outputStream);
        DynamicNote[] noteArray = this.dynamicEditor.getSelectedNotes();
        encoder.writeObject(noteArray);
        encoder.close();
        this.noteClipboard = outputStream.toByteArray();
    }

    protected void cutNotes() {
        this.copyNotes();
        this.dynamicEditor.deleteSelectedNotes();
    }

    protected void stopPlaying() {
        this.scoreThread.stop();
    }

    protected void startPlaying() {
        double startTime = this.setupScorePlayer();
        this.scoreThread = new ScoreThread(this.score);
        this.scoreThread.start(this.clock, startTime);
    }

    private double setupScorePlayer() {
        double startOffset = this.dynamicEditor.getStartOffset() * this.timeScale;
        double chaseUntil = this.synth.getCurrentTime() + 0.2;
        this.scorePlayer.setChaseUntil(chaseUntil);
        double startTime = chaseUntil - startOffset;
        double stopAfter = startTime + this.dynamicEditor.getStopOffset() * this.timeScale;
        this.scorePlayer.setStopAfter(stopAfter);
        return startTime;
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.lineOut.stop();
        this.synth.stop();
        this.dynamicEditor.elementPlayed(null);
    }

    public void saveSequenceAs() {
        File file = EasyFileChooser.chooseSaveFileXML("Select a folder and a name for saving.", this.frame, this.lastFile);
        if (file != null) {
            this.saveSequence(file);
        }
    }

    private void saveSequence(File file) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            XMLEncoder encoder = new XMLEncoder(os);
            encoder.writeObject(this.score);
            encoder.close();
            this.lastFile = file;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void loadSequence() {
        File file = EasyFileChooser.chooseOpenFileXML("Select a file to load a score from.", this.frame, this.lastFile);
        if (file != null) {
            try {
                FileInputStream os = new FileInputStream(file);
                XMLDecoder decoder = new XMLDecoder(os);
                this.score = (Score)decoder.readObject();
                decoder.close();
                this.sequence = (DynamicTrack)this.score.getElements().get(0);
                this.dynamicEditor.setDynamicTrack(this.sequence);
                this.validate();
                this.dynamicEditor.repaint();
                this.lastFile = file;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public static void main(String[] args) {
        DynamicScoreApplet applet = new DynamicScoreApplet();
        JAppletFrame frame = new JAppletFrame("DynamicScoreEditor V0.0.9, (C) 2011 Mobileer Inc - BETA - Do Not Distribute", applet);
        applet.setFrame(frame);
        frame.setSize(1200, 1000);
        frame.setVisible(true);
        frame.test();
    }
}

