/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model;

import com.softsynth.wire.AlertUser;
import com.syntona.model.AddModuleCommand;
import com.syntona.model.ClearPatchCommand;
import com.syntona.model.ConnectJacksCommand;
import com.syntona.model.GUIService;
import com.syntona.model.KickModuleCommand;
import com.syntona.model.MoveModuleCommand;
import com.syntona.model.PassMessageCommand;
import com.syntona.model.SyntonaCommand;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.SyntonaPreferences;
import com.syntona.model.core.CoreBundle;
import com.syntona.model.core.PatchModule;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.model.jsyn.JSynBundle;
import com.syntona.model.music.MusicBundle;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.EngineController;
import com.syntona.plugin.Jack;
import com.syntona.plugin.Loadable;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.PatchMessageDouble;
import com.syntona.plugin.SyntonaModule;
import com.syntona.plugin.WireTime;
import com.syntona.tools.ScheduledQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SyntonaEngine
implements Runnable,
EngineController,
Loadable {
    private PatchModule topPatchModule;
    private PatchModulePresenter topPatchPresenter;
    private PatchModulePresenter frontPatchPresenter;
    private ScheduledQueue commandQueue;
    private HashMap<String, Bundle> bundles = new HashMap();
    private Thread thread;
    private volatile boolean go;
    private static SyntonaEngine syntonaEngine;
    private WireTime engineTime;
    private GUIService guiService;
    private HashMap<Integer, ModulePresenter> presentersById = new HashMap();
    private SyntonaPreferences preferences = SyntonaPreferences.getInstance();
    private EngineMenuItemAction saveMenuItemAction;
    private EngineMenuItemAction openMenuItemAction;
    private EngineMenuItemAction loadSubMenuItemAction;
    private byte[] pasteBuffer;
    private EngineMenuItemAction detachMenuItemAction;
    private boolean loading;
    private static int nextId;
    private static final Logger logger;

    static {
        nextId = 1;
        logger = Logger.getLogger(SyntonaEngine.class.getName());
    }

    private SyntonaEngine() {
        this.commandQueue = new ScheduledQueue();
        this.loadBundles();
        this.engineTime = new WireTime();
        this.topPatchPresenter = (PatchModulePresenter)this.addModuleNow(CoreBundle.getInstance(), null, "patch", 20, 20);
        this.topPatchModule = (PatchModule)this.topPatchPresenter.getModule();
        this.topPatchModule.setName("top");
    }

    public static SyntonaEngine getInstance() {
        if (syntonaEngine == null) {
            syntonaEngine = new SyntonaEngine();
        }
        return syntonaEngine;
    }

    private void loadBundles() {
        this.addBundle(CoreBundle.getInstance());
        this.addBundle(MusicBundle.getInstance());
        this.addBundle(JSynBundle.getInstance());
    }

    private void addBundle(Bundle bundle) {
        this.bundles.put(bundle.getName(), bundle);
    }

    @Override
    public void start() {
        this.startBundles();
        this.startEngineThread();
    }

    private void startBundles() {
        for (Bundle bundle : this.getBundles()) {
            bundle.start();
        }
    }

    private void startEngineThread() {
        this.stopEngineThread();
        this.thread = new Thread(this);
        this.go = true;
        this.thread.start();
    }

    @Override
    public void stop() {
        this.topPatchModule.shutdown();
        this.stopEngineThread();
        this.stopBundles();
    }

    private void stopBundles() {
        for (Bundle bundle : this.getBundles()) {
            bundle.stop();
        }
    }

    private void stopEngineThread() {
        this.go = false;
    }

    @Override
    public PatchModulePresenter getTopPatch() {
        return this.topPatchPresenter;
    }

    public PatchModulePresenter getFrontPatchPresenter() {
        return this.frontPatchPresenter;
    }

    public void setFrontPatchPresenter(PatchModulePresenter frontPatchPresenter) {
        this.frontPatchPresenter = frontPatchPresenter;
        if (this.saveMenuItemAction != null) {
            this.saveMenuItemAction.setEnabled(frontPatchPresenter != null);
        }
        if (this.loadSubMenuItemAction != null) {
            this.loadSubMenuItemAction.setEnabled(frontPatchPresenter != null);
        }
    }

    public void send(SyntonaCommand command) {
        this.send(this.getCurrentTime(), command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(WireTime timeStamp, SyntonaCommand command) {
        ScheduledQueue scheduledQueue = this.commandQueue;
        synchronized (scheduledQueue) {
            this.commandQueue.add(timeStamp, command);
            this.commandQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: while (true) {
            try {
                while (this.go) {
                    ScheduledQueue scheduledQueue = this.commandQueue;
                    synchronized (scheduledQueue) {
                        while (this.commandQueue.isEmpty()) {
                            this.commandQueue.wait();
                        }
                    }
                    WireTime nextTime = this.commandQueue.getNextTime();
                    double secondsToWait = nextTime.getTime() - this.getCurrentTime().getTime();
                    long millis = (long)(1000.0 * secondsToWait);
                    if (millis < 1L) {
                        SyntonaCommand command = (SyntonaCommand)this.commandQueue.removeNext(nextTime);
                        if (command == null) continue;
                        if (nextTime.isLaterThan(this.engineTime)) {
                            this.engineTime = nextTime;
                        }
                        command.execute();
                        continue;
                    }
                    ScheduledQueue scheduledQueue2 = this.commandQueue;
                    synchronized (scheduledQueue2) {
                        this.commandQueue.wait(millis);
                        continue block8;
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long drainCommandQueue(long msec) throws InterruptedException {
        long endTime = System.currentTimeMillis() + msec;
        long timeout = msec;
        ScheduledQueue scheduledQueue = this.commandQueue;
        synchronized (scheduledQueue) {
            while (!this.commandQueue.isEmpty() && timeout > 0L) {
                timeout = endTime - System.currentTimeMillis();
                this.commandQueue.wait(timeout);
            }
        }
        return timeout;
    }

    @Override
    public Collection<Bundle> getBundles() {
        return this.bundles.values();
    }

    @Override
    public void sendPatchMessageDouble(Jack inJack, double value) {
        PatchMessageDouble message = new PatchMessageDouble(value);
        this.sendPassMessage(inJack, message);
    }

    public void sendPassMessage(Jack jack, PatchMessage message) {
        this.send(new PassMessageCommand(jack, message));
    }

    @Override
    public void sendPassMessage(WireTime timeStamp, Jack jack, PatchMessage message) {
        PassMessageCommand cmd = new PassMessageCommand(jack, message);
        this.send(timeStamp, cmd);
    }

    @Override
    public void sendAddModule(Bundle bundle, PatchModulePresenter parentPresenter, String type) {
        this.sendAddModule(bundle, parentPresenter, type, 20, 20);
    }

    @Override
    public void sendAddModule(Bundle bundle, PatchModulePresenter parentPresenter, String type, int x, int y) {
        AddModuleCommand cmd = new AddModuleCommand(bundle, parentPresenter, type, x, y);
        this.send(cmd);
    }

    @Override
    public void sendKickModule(SyntonaModule module) {
        this.send(new KickModuleCommand(module));
    }

    @Override
    public WireTime getCurrentTime() {
        return new WireTime();
    }

    @Override
    public WireTime getEngineTime() {
        return this.engineTime;
    }

    @Override
    public Action[] getFileMenuItemActions() {
        ArrayList<AbstractAction> items = new ArrayList<AbstractAction>();
        AbstractAction abstractAction = new AbstractAction("New"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyntonaEngine.this.topPatchPresenter.showMainEditor();
            }
        };
        items.add(abstractAction);
        this.openMenuItemAction = new EngineMenuItemAction("Open..."){

            @Override
            public void execute() {
                SyntonaEngine.getInstance().menuOpen();
            }
        };
        items.add(this.openMenuItemAction);
        this.loadSubMenuItemAction = new EngineMenuItemAction("Load Subpatch..."){

            @Override
            public void execute() {
                SyntonaEngine.getInstance().menuLoadSubPatch();
            }
        };
        items.add(this.loadSubMenuItemAction);
        this.saveMenuItemAction = new EngineMenuItemAction("Save"){

            @Override
            public void execute() {
                SyntonaEngine.getInstance().menuSave();
            }
        };
        this.saveMenuItemAction.setEnabled(false);
        items.add(this.saveMenuItemAction);
        items.add(new EngineMenuItemAction("Save As..."){

            @Override
            public void execute() {
                SyntonaEngine.getInstance().menuSaveAs();
            }
        });
        this.detachMenuItemAction = new EngineMenuItemAction("Detach File"){

            @Override
            public void execute() {
                SyntonaEngine.getInstance().menuDetachFile();
            }
        };
        this.detachMenuItemAction.setEnabled(true);
        items.add(this.detachMenuItemAction);
        items.add(new EngineMenuItemAction("Export Java Source As..."){

            @Override
            public void execute() {
                SyntonaEngine.getInstance().exportJavaSourceAs();
            }
        });
        items.add(new EngineMenuItemAction("Quit"){

            @Override
            public void execute() {
                SyntonaEngine.getInstance().menuQuit();
            }
        });
        return items.toArray(new Action[0]);
    }

    protected void menuQuit() {
        try {
            if (!this.saveTopIfDirty()) {
                logger.info("quit");
                this.stopEngineThread();
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    protected void menuOpen() {
        File openFile = this.getGUIService().askOpenFile(this.preferences.getLastLoadFile());
        if (openFile != null) {
            this.loadFromFile(openFile);
        }
    }

    protected void menuLoadSubPatch() {
        File openFile = this.getGUIService().askOpenFile(this.preferences.getLastLoadFile());
        if (openFile != null) {
            this.loadSubpatchFromFile(openFile);
        }
    }

    protected void menuNew() {
        logger.info("Create NEW project");
    }

    protected void menuDetachFile() {
        logger.info("save project");
        if (this.getFrontPatchPresenter() != null) {
            this.getFrontPatchPresenter().setFile(null);
        }
    }

    protected void menuSave() {
        logger.info("save project");
        if (this.getFrontPatchPresenter() != null) {
            PatchModulePresenter topSavePatch = this.getFrontPatchPresenter().getTopOfSaveTree();
            File file = topSavePatch.getFile();
            if (file == null) {
                this.saveAs(topSavePatch);
            } else {
                this.saveToFile(topSavePatch, file);
            }
        }
    }

    @Override
    public boolean saveTopIfDirty() throws ParserConfigurationException {
        return this.topPatchPresenter.saveIfDirty();
    }

    @Override
    public void menuSaveAs() {
        if (this.getFrontPatchPresenter() != null) {
            this.saveAs(this.getFrontPatchPresenter());
        }
    }

    public void saveAs(PatchModulePresenter presenter) {
        File saveFile;
        File lastSaveFile;
        File file = presenter.getFile();
        if (file == null && (lastSaveFile = this.preferences.getLastSaveFile()) != null) {
            file = new File(lastSaveFile.getParentFile(), "Untitled.xml");
        }
        if ((saveFile = this.getGUIService().askSaveFile(file)) != null) {
            logger.info("saveFile = " + saveFile.getAbsolutePath());
            this.saveToFile(presenter, saveFile);
            this.saveMenuItemAction.setEnabled(true);
        }
    }

    private void saveToFile(PatchModulePresenter presenter, File saveFile) {
        try {
            presenter.save(saveFile);
            logger.info("Saved to file: " + saveFile);
            this.preferences.setLastSaveFile(saveFile);
        }
        catch (Exception e) {
            AlertUser.showError(e);
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void loadFromFile() {
        this.loadFromFile(this.preferences.getLastLoadFile());
    }

    public boolean isLoading() {
        return this.loading;
    }

    private void setLoading(final boolean b) {
        this.send(new SyntonaCommand(){

            @Override
            public void execute() {
                SyntonaEngine.this.loading = b;
            }

            @Override
            public void undo() {
            }
        });
    }

    private void loadSubpatchFromFile(File loadFile) {
        try {
            try {
                if (loadFile.exists() && this.getFrontPatchPresenter() != null) {
                    this.setLoading(true);
                    this.getFrontPatchPresenter().loadSubPatch(loadFile);
                    this.preferences.setLastLoadFile(loadFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setLoading(false);
            }
        }
        finally {
            this.setLoading(false);
        }
    }

    private void loadFromFile(File loadFile) {
        try {
            try {
                if (loadFile.exists()) {
                    this.setLoading(true);
                    this.topPatchPresenter.load(loadFile);
                    this.topPatchPresenter.showMainEditor();
                    this.saveMenuItemAction.setEnabled(true);
                    this.openMenuItemAction.setEnabled(false);
                    this.preferences.setLastLoadFile(loadFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setLoading(false);
            }
        }
        finally {
            this.setLoading(false);
        }
    }

    public void exportJavaSource(File exportFile) {
        SyntonaExporter exporter;
        boolean success;
        if (this.getFrontPatchPresenter() != null && (success = (exporter = new SyntonaExporter()).export(this.getFrontPatchPresenter(), exportFile))) {
            logger.info("Exported to file: " + exportFile);
            this.preferences.setLastExportFile(exportFile);
        }
    }

    protected void exportJavaSourceAs() {
        logger.info("Export project");
        File lastExportFile = this.preferences.getLastExportFile();
        System.out.println("lastExportFile = " + lastExportFile.getAbsolutePath());
        File exportFile = this.getGUIService().askSaveFile(lastExportFile, ".java");
        if (exportFile != null) {
            this.exportJavaSource(exportFile);
        }
    }

    @Override
    public Action[] getEditMenuItemActions() {
        ArrayList<AbstractAction> items = new ArrayList<AbstractAction>();
        items.add(new MenuActionCopy());
        items.add(new MenuActionPaste());
        items.add(new MenuActionDelete());
        return items.toArray(new Action[0]);
    }

    public GUIService getGUIService() {
        return this.guiService;
    }

    @Override
    public void waitForFinish() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setGUIService(GUIService guiService) {
        this.guiService = guiService;
    }

    public void sendConnectJacks(Jack sourceJack, Jack targetJack) {
        SyntonaModule sourceModule = sourceJack.getModule();
        SyntonaModule targetModule = targetJack.getModule();
        this.sendConnectJacks(sourceModule.getId(), sourceJack.getName(), targetModule.getId(), targetJack.getName());
    }

    @Override
    public void sendConnectJacks(int sourceModuleId, String sourceJackName, int targetModuleId, String targetJackName) {
        ConnectJacksCommand cmd = new ConnectJacksCommand(sourceModuleId, sourceJackName, targetModuleId, targetJackName);
        this.send(cmd);
    }

    public ModulePresenter getPresenterById(int moduleId) {
        return this.presentersById.get(moduleId);
    }

    public SyntonaModule getModuleById(int moduleId) {
        return this.getPresenterById(moduleId).getModule();
    }

    @Override
    public Bundle getBundle(String name) {
        return this.bundles.get(name);
    }

    @Override
    public void sendMoveModule(int moduleId, int x, int y) {
        MoveModuleCommand cmd = new MoveModuleCommand(moduleId, x, y);
        this.send(cmd);
    }

    @Override
    public ModulePresenter addModuleNow(Bundle bundle, PatchModulePresenter parentPresenter, String type, int x, int y) {
        ModulePresenter addedPresenter = bundle.createModule(type, parentPresenter);
        addedPresenter.getView().setLocation(x, y);
        SyntonaModule module = addedPresenter.getModule();
        module.setId(nextId++);
        this.presentersById.put(module.getId(), addedPresenter);
        if (parentPresenter != null) {
            parentPresenter.add(addedPresenter);
        }
        return addedPresenter;
    }

    @Override
    public void sendClearTopPatch() {
        this.saveMenuItemAction.setEnabled(false);
        this.openMenuItemAction.setEnabled(true);
        ClearPatchCommand cmd = new ClearPatchCommand(this.topPatchPresenter);
        this.send(cmd);
    }

    public void sendDeleteModule(final ModulePresenter presenter) {
        this.send(new SyntonaCommand(){

            @Override
            public void execute() {
                presenter.delete();
            }

            @Override
            public void undo() {
            }
        });
    }

    class EngineMenuItemAction
    extends AbstractAction
    implements SyntonaCommand {
        public EngineMenuItemAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SyntonaEngine.this.send(this);
        }

        @Override
        public void execute() {
        }

        @Override
        public void undo() {
        }
    }

    private class MenuActionCopy
    extends AbstractAction
    implements SyntonaCommand {
        ModulePresenter[] presenters;

        public MenuActionCopy() {
            super("Copy");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 4));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.presenters = SyntonaEngine.this.guiService.getSelectedModulePresenters();
            if (this.presenters != null && this.presenters.length > 0) {
                SyntonaEngine.this.send(this);
            }
        }

        @Override
        public void execute() {
            PatchModulePresenter patch = this.presenters[0].getParent();
            try {
                SyntonaEngine.this.pasteBuffer = patch.copy(this.presenters);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void undo() {
        }
    }

    private class MenuActionDelete
    extends AbstractAction
    implements SyntonaCommand {
        ModulePresenter[] presenters;

        public MenuActionDelete() {
            super("Delete");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.presenters = SyntonaEngine.this.guiService.getSelectedModulePresenters();
            if (this.presenters != null) {
                SyntonaEngine.this.send(this);
            }
        }

        @Override
        public void execute() {
            ModulePresenter[] modulePresenterArray = this.presenters;
            int n = this.presenters.length;
            int n2 = 0;
            while (n2 < n) {
                ModulePresenter presenter = modulePresenterArray[n2];
                presenter.delete();
                ++n2;
            }
        }

        @Override
        public void undo() {
        }
    }

    private class MenuActionPaste
    extends AbstractAction
    implements SyntonaCommand {
        ModulePresenter[] presenters;

        public MenuActionPaste() {
            super("Paste");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 4));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SyntonaEngine.this.pasteBuffer != null) {
                SyntonaEngine.this.send(this);
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public void execute() {
            if (SyntonaEngine.this.frontPatchPresenter != null) {
                try {
                    try {
                        SyntonaEngine.this.loading = true;
                        SyntonaEngine.this.frontPatchPresenter.paste(SyntonaEngine.this.pasteBuffer);
                    }
                    catch (ParserConfigurationException e) {
                        e.printStackTrace();
                        SyntonaEngine.this.setLoading(false);
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                        SyntonaEngine.this.setLoading(false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        SyntonaEngine.this.setLoading(false);
                    }
                }
                finally {
                    SyntonaEngine.this.setLoading(false);
                }
            }
        }

        @Override
        public void undo() {
        }
    }
}

