/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.ports.UnitInputPort;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.core.PatchModule;
import com.syntona.model.jsyn.InputAudioJack;
import com.syntona.model.jsyn.OutputAudioJack;
import com.syntona.model.jsyn.UnitPortModule;
import com.syntona.plugin.CopyConnectionHandler;
import com.syntona.plugin.Jack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModule;

public class AudioInputJackModule
extends UnitPortModule {
    private OutputAudioJack output = new OutputAudioJack((SyntonaModule)this, "output", "signal from parent");
    InputAudioJack input;

    public AudioInputJackModule() {
        this.output.setSynthPort(this.tiePoint.output);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.input != null) {
            this.input.setName(name);
        }
    }

    @Override
    public void removedFromPatch() {
        this.getParent().removeJack(this.input);
        super.removedFromPatch();
    }

    @Override
    public void addedToPatch(PatchModule parent) {
        super.addedToPatch(parent);
        this.input = new InputAudioJack(parent, this.getName(), this.tiePoint.input, 0){

            @Override
            public void passMessage(PatchMessage msg) {
                AudioInputJackModule.this.output.passMessage(msg);
                super.passMessage(msg);
            }
        };
        this.input.setHelp("input to patch");
        this.output.setConnectionHandler(new CopyConnectionHandler(this.input));
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        super.exportJavaSource(exporter, phase);
        IndentingWriter writer = exporter.getWriter();
        switch (phase) {
            case 1: {
                writer.println("public UnitInputPort " + this.input.getName() + ";");
                break;
            }
            case 3: {
                writer.println("addPort( " + this.input.getName() + " = " + this.getExportName() + ".input, \"" + this.input.getName() + "\");");
                break;
            }
            case 5: {
                double max;
                UnitInputPort inPort = this.input.getUnitInputPort();
                double min = inPort.getMinimum();
                double value = inPort.getValue();
                if (min > value) {
                    min = value <= 0.0 ? 2.0 * value : 0.5 * value;
                }
                if ((max = inPort.getMaximum()) < value) {
                    max = value <= 0.0 ? 0.5 * value : 2.0 * value;
                }
                writer.println(String.valueOf(this.input.getName()) + ".setup(" + min + ", " + value + ", " + max + ");");
                break;
            }
            case 7: {
                if ("frequency".equals(this.getName().toLowerCase())) {
                    writer.println("this.frequency.set( frequency, timeStamp );");
                    break;
                }
                if (!"amplitude".equals(this.getName().toLowerCase())) break;
                writer.println("this.amplitude.set( amplitude, timeStamp );");
            }
        }
    }

    @Override
    public void noteOn(double frequency, double amplitude) {
        if ("frequency".equals(this.getName().toLowerCase())) {
            this.input.setValue(frequency);
        } else if ("amplitude".equals(this.getName().toLowerCase())) {
            this.input.setValue(amplitude);
        }
    }

    @Override
    public Jack[] getJacksToEdit() {
        Jack[] jacksToEdit = new Jack[]{this.input};
        return jacksToEdit;
    }
}

