/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.softsynth.tools.view.JTextFieldDirty;
import com.softsynth.util.NumericOutput;
import com.syntona.plugin.DoubleRangeModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTextFieldDouble
extends JTextFieldDirty {
    DoubleRangeModel mModel;

    public JTextFieldDouble(DoubleRangeModel model, int numCharacters) {
        super(numCharacters);
        this.mModel = model;
        this.updateText();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    double val = Double.valueOf(JTextFieldDouble.this.getText());
                    JTextFieldDouble.this.mModel.setValue(val);
                }
                catch (NumberFormatException e) {
                    JTextFieldDouble.this.setText("Error!");
                    JTextFieldDouble.this.selectAll();
                }
            }
        });
        this.mModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTextFieldDouble.this.updateText();
            }
        });
    }

    private void updateText() {
        super.setText(NumericOutput.doubleToString(this.mModel.getValue(), 1, 4));
        this.markClean();
    }

    public double getValue() throws NumberFormatException {
        double val = Double.valueOf(this.getText());
        return val;
    }

    public void setValue(double value) {
        this.mModel.setValue(value);
    }
}

