/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.tools;

import java.io.File;

public class FileTools {
    public static String getBasePath() {
        return String.valueOf(new File("").getAbsolutePath()) + File.separator;
    }

    static String makePathRelative(String path) {
        return FileTools.stripPrefix(path, FileTools.getBasePath());
    }

    static String makePathPortable(String path) {
        String result = FileTools.stripPrefix(path, FileTools.getBasePath());
        return FileTools.convertFileSeparatorsToJava(result);
    }

    public static String makePathRelative(String path, File targetFile) {
        String targetPath;
        if (targetFile != null && path.startsWith(targetPath = String.valueOf(targetFile.getParent()) + File.separator)) {
            path = path.substring(targetPath.length(), path.length());
            return FileTools.convertFileSeparatorsToJava(path);
        }
        return FileTools.makePathPortable(path);
    }

    public static File resolveRelativePath(File referenceFile, String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return file;
        }
        if (referenceFile != null) {
            File dir = referenceFile.getParentFile();
            while (dir != null) {
                file = new File(dir, fileName);
                if (file.exists()) {
                    return file;
                }
                dir = dir.getParentFile();
            }
        }
        if ((file = new File(fileName)).exists()) {
            return file;
        }
        System.err.println("Could not resolve file " + fileName + " from " + referenceFile);
        return null;
    }

    static String stripPrefix(String text, String prefix) {
        if (prefix != null && text.startsWith(prefix)) {
            text = text.substring(prefix.length(), text.length());
        }
        return text;
    }

    static String convertChars(String path, char fromChar, char toChar) {
        if (path == null) {
            return path;
        }
        StringBuffer sbuf = new StringBuffer(path);
        int i = 0;
        while (i < sbuf.length()) {
            if (sbuf.charAt(i) == fromChar) {
                sbuf.setCharAt(i, toChar);
            }
            ++i;
        }
        return sbuf.toString();
    }

    static String convertFileSeparatorsToJava(String path) {
        return FileTools.convertChars(path, File.separatorChar, '/');
    }

    public static String convertFileSeparatorsToHost(String path) {
        return FileTools.convertChars(path, '/', File.separatorChar);
    }

    public static File findExistingParent(String fileName) {
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent = parent.getParentFile();
        }
        return parent;
    }
}

