/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.iptoxy;

import com.transjam.server.ClientMessage;
import com.transjam.server.ClientTracker;
import com.transjam.server.IPAddressToLocation;
import com.transjam.server.MessageQueue;
import com.transjam.server.Server;
import com.transjam.util.ClientLocation;
import com.transjam.util.ProtocolWriter;
import com.transjam.util.TransjamMessage;
import java.net.InetAddress;

public class IPLocationDaemon
implements Runnable {
    private volatile boolean go;
    private MessageQueue clientQueue;
    private IPAddressToLocation locator;
    private ProtocolWriter writer;
    private Server server;
    private Thread thread;

    public IPLocationDaemon(Server server, IPAddressToLocation pLocator) {
        this.server = server;
        this.clientQueue = new MessageQueue();
        this.locator = pLocator;
        this.writer = new ProtocolWriter();
    }

    public void requestLocation(ClientTracker client) {
        if (this.clientQueue.size() < 200) {
            this.clientQueue.send(client);
        }
    }

    public void start() {
        this.stop();
        this.thread = new Thread(this);
        this.go = true;
        this.thread.start();
    }

    public void stop() {
        this.go = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.thread = null;
        }
    }

    @Override
    public void run() {
        while (this.go) {
            try {
                ClientTracker client = (ClientTracker)this.clientQueue.waitForMessage();
                InetAddress address = client.getSocket().getInetAddress();
                ClientLocation location = this.locator.getLocation(address);
                if (location == null) continue;
                TransjamMessage tmsg = new TransjamMessage();
                tmsg.command = "userxy";
                tmsg.put("uid", client.getUserID());
                tmsg.put("lat", location.latitude);
                tmsg.put("lon", location.longitude);
                ClientMessage cmsg = new ClientMessage(client, tmsg);
                this.server.postMessage(cmsg);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

