/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.server;

import com.transjam.server.ClientTracker;
import com.transjam.server.Server;
import com.transjam.util.DebugLog;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ClientAccepter
extends Thread {
    private ServerSocket loginSocket;
    private int portNum = 1;
    Server server;
    private static int nextID = 0;
    public volatile boolean go = true;

    public ClientAccepter(Server server, int portNum) throws IOException, SecurityException {
        this.server = server;
        this.portNum = portNum;
        this.loginSocket = new ServerSocket(portNum);
    }

    public synchronized int getNextID() {
        if (++nextID == 0) {
            nextID = 1;
        }
        return nextID;
    }

    public ClientTracker makeClient(Socket socket) throws IOException {
        return new ClientTracker(this.server, this.getNextID(), socket, this.server.getTimeoutMSec());
    }

    @Override
    public void run() {
        try {
            while (this.go) {
                Socket socket = this.loginSocket.accept();
                DebugLog.debugln(117, "ClientAccepter: got client at " + socket);
                ClientTracker client = this.makeClient(socket);
                socket.setKeepAlive(true);
                client.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.go = false;
        try {
            this.loginSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

