/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.util;

import com.transjam.util.XMLListener;
import com.transjam.util.XMLTools;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.StreamCorruptedException;
import java.util.Hashtable;

public class XMLReader
extends PushbackInputStream {
    XMLListener listener;
    static final int IDLE = 0;
    static final int INTAG = 0;
    static int depth = 0;
    static final int STATE_TOP = 0;
    static final int STATE_TAG_NAME = 1;
    static final int STATE_TAG_FIND_ANGLE = 2;
    static final int STATE_TAG_ATTR_NAME = 3;
    static final int STATE_TAG_FIND_EQUAL = 4;
    static final int STATE_TAG_FIND_QUOTE = 5;
    static final int STATE_TAG_ATTR_VALUE = 6;
    static final int STATE_CONTENT = 7;
    static final int STATE_CHECK_END = 8;
    static final int STATE_TAG_SKIP = 9;

    public void setXMLListener(XMLListener listener) {
        this.listener = listener;
    }

    public XMLReader(InputStream stream) {
        super(stream);
    }

    public void parse() throws IOException {
        int i;
        while ((i = this.read()) >= 0) {
            char c = (char)i;
            if (c == '<') {
                this.parseElement();
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new StreamCorruptedException("Unexpected character. This doesn't look like an XML file!");
        }
    }

    String charToString(char c) {
        String s;
        switch (c) {
            case '\r': {
                s = "\\r";
                break;
            }
            case '\n': {
                s = "\\n";
                break;
            }
            case '\t': {
                s = "\\t";
                break;
            }
            default: {
                s = Character.isWhitespace(c) ? " " : "" + c;
            }
        }
        return s;
    }

    boolean isStringWhite(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void parseElement() throws IOException {
        int state = 1;
        StringBuffer tagName = new StringBuffer();
        StringBuffer name = null;
        StringBuffer value = null;
        StringBuffer content = null;
        boolean ifEmpty = false;
        boolean endTag = false;
        boolean done = false;
        boolean skipWhiteSpace = true;
        char endQuote = '\"';
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        while (!done) {
            char c;
            do {
                int i;
                if ((i = this.read()) < 0) {
                    throw new EOFException("EOF inside element!");
                }
                c = (char)i;
            } while (skipWhiteSpace && Character.isWhitespace(c));
            skipWhiteSpace = false;
            switch (state) {
                case 1: {
                    if (Character.isWhitespace(c)) {
                        skipWhiteSpace = true;
                        state = 2;
                        break;
                    }
                    if (c == '/') {
                        ifEmpty = true;
                        state = 2;
                        break;
                    }
                    if (c == '>') {
                        if (endTag) {
                            this.listener.endElement(tagName.toString());
                            done = true;
                            break;
                        }
                        this.listener.beginElement(tagName.toString(), attributes, ifEmpty);
                        state = 7;
                        break;
                    }
                    if (c == '?') {
                        state = 9;
                        break;
                    }
                    if (c == '!') {
                        state = 9;
                        break;
                    }
                    tagName.append(c);
                    break;
                }
                case 9: {
                    if (c != '>') break;
                    done = true;
                    break;
                }
                case 2: {
                    if (c == '/') {
                        ifEmpty = true;
                        break;
                    }
                    if (c == '>') {
                        if (endTag) {
                            this.listener.endElement(tagName.toString());
                            done = true;
                            break;
                        }
                        this.listener.beginElement(tagName.toString(), attributes, ifEmpty);
                        state = 7;
                        done = ifEmpty;
                        break;
                    }
                    state = 3;
                    name = new StringBuffer();
                    name.append(c);
                    break;
                }
                case 3: {
                    if (Character.isWhitespace(c)) {
                        skipWhiteSpace = true;
                        state = 4;
                        break;
                    }
                    if (c == '=') {
                        skipWhiteSpace = true;
                        state = 5;
                        break;
                    }
                    name.append(c);
                    break;
                }
                case 4: {
                    if (c == '=') {
                        skipWhiteSpace = true;
                        state = 5;
                        break;
                    }
                    throw new StreamCorruptedException("Found " + this.charToString(c) + ", expected =.");
                }
                case 5: {
                    if (c == '\"') {
                        state = 6;
                        value = new StringBuffer();
                        endQuote = '\"';
                        break;
                    }
                    if (c == '\'') {
                        state = 6;
                        value = new StringBuffer();
                        endQuote = '\'';
                        break;
                    }
                    throw new StreamCorruptedException("Found " + this.charToString(c) + ", expected '\"'.");
                }
                case 6: {
                    if (c == endQuote) {
                        attributes.put(name.toString(), value.toString());
                        skipWhiteSpace = true;
                        state = 2;
                        break;
                    }
                    value.append(c);
                    break;
                }
                case 7: {
                    if (c == '<') {
                        state = 8;
                        String contentString = content.toString();
                        if (!this.isStringWhite(contentString)) {
                            String unescaped = XMLTools.unescapeText(contentString);
                            this.listener.foundContent(unescaped);
                        }
                        content = null;
                        break;
                    }
                    if (content == null) {
                        content = new StringBuffer(128);
                    }
                    content.append(c);
                    break;
                }
                case 8: {
                    if (c == '/') {
                        endTag = true;
                        state = 1;
                        tagName.setLength(0);
                        break;
                    }
                    this.unread(c);
                    this.parseElement();
                    state = 7;
                }
            }
        }
    }

    public static int getAttribute(Hashtable attributes, String key, int defaultValue) {
        String s = (String)attributes.get(key);
        return s == null ? defaultValue : Integer.parseInt(s);
    }

    public static long getAttribute(Hashtable attributes, String key, long defaultValue) {
        String s = (String)attributes.get(key);
        return s == null ? defaultValue : Long.parseLong(s);
    }

    public static double getAttribute(Hashtable attributes, String key, double defaultValue) {
        String s = (String)attributes.get(key);
        return s == null ? defaultValue : Double.valueOf(s);
    }
}

