/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.webdrum;

import com.transjam.client.Client;
import com.transjam.client.ModelProxy;
import com.transjam.drumbox.SongModel;
import com.transjam.util.VerboseDataInputStream;
import com.transjam.util.VerboseDataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class WebSongProxy
extends ModelProxy {
    public WebSongProxy(Client pClient, SongModel pSongModel, String thingName) throws IOException {
        super(pClient, pSongModel, thingName);
    }

    @Override
    public String encodeModelData() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        VerboseDataOutputStream dataOut = new VerboseDataOutputStream(bytesOut);
        SongModel songModel = (SongModel)this.getModel();
        int tempoData = (int)(songModel.getBeatsPerMinute() * 1000.0);
        dataOut.writeInt(tempoData);
        dataOut.writeInt(songModel.getFundamental());
        dataOut.writeInt(songModel.getTuningSelection());
        return bytesOut.toString();
    }

    @Override
    public void decodeModelData(String info) throws IOException {
        VerboseDataInputStream dataIn = new VerboseDataInputStream(new ByteArrayInputStream(info.getBytes()));
        SongModel songModel = (SongModel)this.getModel();
        int tempoData = dataIn.readInt();
        songModel.setBeatsPerMinute((double)tempoData * 0.001);
        songModel.setFundamental(dataIn.readInt());
        songModel.setTuningSelection(dataIn.readInt());
    }
}

