/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.view102.XYController;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;

class FunctionDrawingPad
extends XYController {
    double[] data;
    int lastIndex = 0;
    double lastT = 0.0;
    boolean circular = false;
    int length;
    int startIndex = -1;
    int stopIndex = -1;
    Color selectionColor = Color.gray;

    public FunctionDrawingPad(int numPoints, boolean circular) {
        this(new double[numPoints], circular);
    }

    public FunctionDrawingPad(double[] data, boolean circular) {
        this.circular = circular;
        this.setData(data);
        this.setMinWorldX(0.0);
        this.setMinWorldY(-1.0);
        this.setMaxWorldY(1.0);
    }

    void setData(double[] data) {
        this.length = this.circular ? data.length : data.length - 1;
        this.data = data;
        this.setMaxWorldX(this.length);
    }

    double[] getData() {
        return this.data;
    }

    void setDatum(int index, double value) {
        this.data[index] = value;
        if (this.circular && index == 0) {
            this.data[this.data.length - 1] = value;
        }
    }

    void useXY(int gx, int gy, boolean dragged) {
        int index = (int)this.convertGXtoWX(gx);
        double y0 = this.convertGYtoWY(gy);
        y0 = this.clipWorldY(y0);
        if (index < 0) {
            this.lastIndex = 0;
            this.lastT = y0;
            return;
        }
        if (index > this.length - 1) {
            this.lastIndex = this.length - 1;
            this.lastT = y0;
            return;
        }
        if (dragged) {
            int ix1 = this.lastIndex;
            int ix2 = index;
            double y1 = this.lastT;
            double y2 = y0;
            if (ix1 > ix2) {
                int temp = ix1;
                ix1 = ix2;
                ix2 = temp;
                double dtemp = y1;
                y1 = y2;
                y2 = dtemp;
            }
            int i = ix1;
            while (i < ix2) {
                double y = y1 + (y2 - y1) * ((double)(i - ix1) / (double)(ix2 - ix1));
                this.setDatum(i, y);
                ++i;
            }
        }
        this.lastIndex = index;
        this.lastT = y0;
        this.repaint();
    }

    @Override
    public boolean mouseDown(Event evt, int x, int y) {
        this.useXY(x, y, false);
        return true;
    }

    @Override
    public boolean mouseDrag(Event evt, int x, int y) {
        this.useXY(x, y, true);
        return true;
    }

    @Override
    public boolean mouseUp(Event evt, int x, int y) {
        this.useXY(x, y, true);
        this.updateData();
        return true;
    }

    void updateData() {
    }

    void smooth() {
        double tempZ2 = this.data[0];
        double tempZ1 = (this.data[0] + 2.0 * this.data[1] + this.data[2]) * 0.25;
        int i = 2;
        while (i < this.data.length - 1) {
            this.setDatum(i - 2, tempZ2);
            tempZ2 = tempZ1;
            tempZ1 = (this.data[i - 1] + 2.0 * this.data[i] + this.data[i + 1]) * 0.25;
            ++i;
        }
        this.setDatum(this.data.length - 2, tempZ2);
        this.setDatum(this.data.length - 1, tempZ1);
        this.repaint();
    }

    void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    void setSelectionStart(int startIndex) {
        this.startIndex = startIndex;
    }

    int setSelectionStart() {
        return this.startIndex;
    }

    void setSelectionStop(int stopIndex) {
        this.stopIndex = stopIndex;
    }

    int setSelectionStop() {
        return this.stopIndex;
    }

    void drawBackground(Graphics g) {
        int width = this.bounds().width;
        int height = this.bounds().height;
        if (this.startIndex < 0 || this.stopIndex < this.startIndex) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        } else {
            int gx0 = this.convertWXtoGX(this.startIndex);
            int gx1 = this.convertWXtoGX(this.stopIndex);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, gx0, height);
            g.fillRect(gx1, 0, width - gx1, height);
            g.setColor(this.selectionColor);
            g.fillRect(gx0, 0, gx1 - gx0, height);
        }
    }

    @Override
    public void paint(Graphics g) {
        int gx1 = 0;
        int gy1 = 0;
        this.drawBackground(g);
        g.setColor(this.getForeground());
        int i = 0;
        while (i < this.length) {
            double wy = this.data[i];
            int gx2 = this.convertWXtoGX(i);
            int gy2 = this.convertWYtoGY(wy);
            if (i > 0) {
                g.drawLine(gx1, gy1, gx2, gy2);
            }
            gx1 = gx2;
            gy1 = gy2;
            ++i;
        }
    }
}

