/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.LinearLag;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.PinkNoise;
import com.softsynth.jsyn.RedNoise;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthUnit;
import com.softsynth.jsyn.WhiteNoise;
import com.softsynth.jsyn.view11x.DecibelPortFader;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.PortFader;
import com.softsynth.jsyn.view11x.SynthScope;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class HearNoise
extends Applet {
    LineOut lineOut;
    MultiplyUnit ampUnit;
    LinearLag lagUnit;
    SynthScope scope;
    PortFader freqFader;
    PortFader ampFader;
    Checkbox[] sourceBoxes;
    Vector sounds;
    Vector names;
    Panel cboxPanel;
    Panel faderPanel;
    SoundWrapper previous = null;

    public static void main(String[] args) {
        HearNoise applet = new HearNoise();
        AppletFrame frame = new AppletFrame("See Noise", applet);
        frame.resize(600, 500);
        frame.show();
        frame.test();
    }

    void makeCBoxPanel() {
        this.cboxPanel = new Panel();
        this.cboxPanel.setLayout(new GridLayout(1, 0));
        CheckboxGroup cbg = new CheckboxGroup();
        this.sourceBoxes = new Checkbox[this.sounds.size()];
        int i = 0;
        while (i < this.sourceBoxes.length) {
            this.sourceBoxes[i] = new Checkbox((String)this.names.elementAt(i), cbg, i == 0);
            this.cboxPanel.add(this.sourceBoxes[i]);
            this.sourceBoxes[i].addItemListener(new OscItemListener(i));
            ++i;
        }
    }

    void enableFrequency(boolean isEnabled) {
        if (isEnabled) {
            this.freqFader.setEnabled(true);
            if (!this.faderPanel.isAncestorOf(this.freqFader)) {
                this.faderPanel.add(this.freqFader);
            }
        } else {
            this.freqFader.setEnabled(false);
            if (this.faderPanel.isAncestorOf(this.freqFader)) {
                this.faderPanel.remove(this.freqFader);
            }
        }
        this.faderPanel.invalidate();
        this.getParent().validate();
        this.repaint();
        this.getToolkit().sync();
    }

    void useNthSound(int soundIndex) throws SynthException {
        if (this.previous != null) {
            this.previous.unit.stop();
        }
        SoundWrapper wrapper = (SoundWrapper)this.sounds.elementAt(soundIndex);
        wrapper.output.connect(this.ampUnit.inputA);
        this.enableFrequency(wrapper.frequency != null);
        wrapper.unit.start();
        this.previous = wrapper;
    }

    @Override
    public void start() {
        this.sounds = new Vector();
        this.names = new Vector();
        this.setLayout(new BorderLayout());
        try {
            Synth.requestVersion(141);
            Synth.startEngine(0);
            WhiteNoise noise1 = new WhiteNoise();
            this.sounds.addElement(new SoundWrapper(noise1, noise1.output, null));
            this.names.addElement("WhiteNoise");
            PinkNoise noise2 = new PinkNoise();
            this.sounds.addElement(new SoundWrapper(noise2, noise2.output, null));
            this.names.addElement("PinkNoise");
            RedNoise noise3 = new RedNoise();
            this.sounds.addElement(new SoundWrapper(noise3, noise3.output, noise3.frequency));
            this.names.addElement("RedNoise");
            this.ampUnit = new MultiplyUnit();
            this.lineOut = new LineOut();
            this.lagUnit = new LinearLag();
            this.lagUnit.time.set(0.05);
            int i = 0;
            while (i < this.sounds.size()) {
                SoundWrapper sound = (SoundWrapper)this.sounds.elementAt(i);
                if (sound.frequency != null) {
                    this.lagUnit.output.connect(sound.frequency);
                }
                ++i;
            }
            this.ampUnit.output.connect(0, this.lineOut.input, 0);
            this.ampUnit.output.connect(0, this.lineOut.input, 1);
            this.scope = new SynthScope();
            this.scope.hideControls();
            this.scope.createProbe(this.ampUnit.output, "Output", Color.yellow);
            this.scope.finish();
            this.add("Center", this.scope);
            Panel controlPanel = new Panel();
            controlPanel.setLayout(new GridLayout(0, 1));
            this.add("South", controlPanel);
            this.faderPanel = new Panel();
            this.faderPanel.setLayout(new GridLayout(0, 1));
            controlPanel.add(this.faderPanel);
            this.freqFader = new ExponentialPortFader(this.lagUnit.input, "Frequency", 440.0, 50.0, Synth.getFrameRate() / 2.0);
            this.faderPanel.add(this.freqFader);
            this.freqFader.setSize(100, 20);
            this.ampFader = new DecibelPortFader(this.ampUnit.inputB, "Level (dB)", -15.0, -60.0, 0.0);
            this.faderPanel.add(this.ampFader);
            this.ampFader.setSize(100, 20);
            this.makeCBoxPanel();
            controlPanel.add(this.cboxPanel);
            this.useNthSound(0);
            this.ampUnit.start();
            this.lagUnit.start();
            this.lineOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.ampUnit.delete();
            this.lagUnit.delete();
            this.lineOut.delete();
            Enumeration enumer = this.sounds.elements();
            while (enumer.hasMoreElements()) {
                SoundWrapper wrapper = (SoundWrapper)enumer.nextElement();
                wrapper.unit.delete();
            }
            this.sounds.removeAllElements();
            this.removeAll();
            Synth.setTrace(0);
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    class OscItemListener
    implements ItemListener {
        int oscIndex;

        public OscItemListener(int oscIndex) {
            this.oscIndex = oscIndex;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            HearNoise.this.useNthSound(this.oscIndex);
        }
    }

    class SoundWrapper {
        SynthUnit unit;
        SynthOutput output;
        SynthInput frequency;

        public SoundWrapper(SynthUnit unit, SynthOutput output, SynthInput frequency) {
            this.unit = unit;
            this.output = output;
            this.frequency = frequency;
        }
    }
}

