/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.RedNoise;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view11x.LabelledFader;
import com.softsynth.jsyn.view11x.PortFader;
import com.softsynth.jsyn.view11x.SynthScope;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;

public class JustAmplitude
extends Applet {
    RedNoise myNoise;
    LineOut lineOut;
    LabelledFader freqFader;
    LabelledFader ampFader;
    SynthScope scope;

    public static void main(String[] args) {
        JustAmplitude applet = new JustAmplitude();
        AppletFrame frame = new AppletFrame("Hear Amplitude", applet);
        frame.resize(500, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        try {
            Synth.startEngine(0);
            this.myNoise = new RedNoise();
            this.lineOut = new LineOut();
            this.myNoise.frequency.set(4000.0);
            this.myNoise.output.connect(0, this.lineOut.input, 0);
            this.myNoise.output.connect(0, this.lineOut.input, 1);
            this.myNoise.amplitude.set(0.0);
            this.lineOut.start();
            this.myNoise.start();
            this.scope = new SynthScope();
            this.add("Center", this.scope);
            this.scope.createProbe(this.myNoise.output, "Output", Color.yellow);
            this.scope.finish();
            Panel faderPanel = new Panel();
            faderPanel.setLayout(new GridLayout(0, 1));
            this.add("North", faderPanel);
            this.ampFader = new PortFader(this.myNoise.amplitude, "Amplitude", 0.0, 0.0, 1.0);
            faderPanel.add(this.ampFader);
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.myNoise.delete();
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }
}

