/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthTable;
import com.softsynth.jsyn.util.BussedVoiceAllocator;
import com.softsynth.jsyn.view11x.LabelledFader;
import com.softsynth.jsyn.view11x.SynthScope;
import com.softsynth.jsyn.view11x.Tweakable;
import com.softsynth.math.ChebyshevPolynomial;
import com.softsynth.math.Polynomial;
import compmus.ChebyshevFader;
import compmus.PitchedVoices;
import compmus.PolyKeyPlayer;
import compmus.TableDrawingPad;
import compmus.WaveShapingOscillator;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PlayWaveShaper
extends Applet
implements Tweakable {
    static final int MAX_NOTES = 5;
    static final int NUM_SHAPERS = 4;
    static final int NUM_FRAMES = 256;
    static final int NUM_LEVELS = 16;
    static final int ON_NOTE = 4;
    static final double BASE_FREQ = 100.0;
    PitchedVoices chebyVoices;
    BussedVoiceAllocator voiceAllocator;
    PolyKeyPlayer keyPlayer;
    Polynomial[] chebyshevs;
    double[] chebData;
    SynthTable table;
    double[] septatonic;
    double[] levels;
    LineOut lineOut;
    ExponentialLag rangeLag;
    SynthEnvelope rangeEnvelope;
    MultiplyUnit gain;
    ExponentialLag gainLag;
    WaveShapingOscillator onVoice;
    String keys;
    ChebyshevFader[] faders;
    TableDrawingPad drawingPad;
    LabelledFader ampFader;
    LabelledFader rangeFader;
    Button keyButton;
    Button clearButton;
    Button smoothButton;
    Checkbox onBox;
    SynthScope scope;
    Dialog scopeDialog;
    Color rangeColor = new Color(200, 140, 210);
    double[] septatonicOctave = new double[]{1.0, 1.125, 1.25, 1.3333333333333333, 1.5, 1.6666666666666667, 1.7777777777777777};

    public static void main(String[] args) {
        PlayWaveShaper applet = new PlayWaveShaper();
        AppletFrame frame = new AppletFrame("Play WaveShaper.", applet);
        frame.resize(600, 600);
        frame.show();
        frame.test();
    }

    double[] buildScale(int numNotes, double fundamental, double[] scale) {
        double[] freqs = new double[numNotes];
        int i = 0;
        while (i < numNotes) {
            int octave = i / scale.length;
            int pitch = i % scale.length;
            freqs[i] = scale[pitch] * fundamental * (double)(1 << octave);
            ++i;
        }
        return freqs;
    }

    int wxToIndex(double wx) {
        int ix = (int)((wx * 0.5 + 0.5) * 256.0);
        return ix;
    }

    void setRange(double range) {
        this.rangeLag.input.set(range);
        this.drawingPad.setSelectionStart(this.wxToIndex(-range));
        this.drawingPad.setSelectionStop(this.wxToIndex(range));
        this.drawingPad.repaint();
    }

    @Override
    public void tweak(int targetIndex, double val) {
        switch (targetIndex) {
            case 0: {
                this.gainLag.input.set(val);
                break;
            }
            case 1: {
                this.setRange(val);
            }
        }
        this.keyButton.requestFocus();
    }

    void sustainNote(boolean isOn) {
        if (isOn) {
            this.onVoice.noteOn(Synth.getTickCount(), this.septatonic[4], 0.25);
        } else {
            this.onVoice.noteOff(Synth.getTickCount());
        }
    }

    void setupGUI() {
        this.setLayout(new GridLayout(0, 1));
        Panel controlPanel = new Panel();
        this.add("North", controlPanel);
        controlPanel.setLayout(new GridLayout(0, 1));
        Panel topPanel = new Panel();
        controlPanel.add(topPanel);
        topPanel.setLayout(new GridLayout(0, 1));
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new GridLayout(1, 0));
        topPanel.add(buttonPanel);
        this.onBox = new Checkbox("Note On");
        buttonPanel.add("Center", this.onBox);
        this.onBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PlayWaveShaper.this.sustainNote(PlayWaveShaper.this.onBox.getState());
                PlayWaveShaper.this.keyButton.requestFocus();
            }
        });
        this.keyButton = new Button("Play Keys");
        buttonPanel.add(this.keyButton);
        this.keyButton.addKeyListener(this.keyPlayer);
        this.addKeyListener(this.keyPlayer);
        this.clearButton = new Button("Clear");
        buttonPanel.add(this.clearButton);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayWaveShaper.this.clearLevels();
            }
        });
        this.smoothButton = new Button("Smooth");
        buttonPanel.add(this.smoothButton);
        this.smoothButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayWaveShaper.this.drawingPad.smooth();
                PlayWaveShaper.this.drawingPad.updateData();
                PlayWaveShaper.this.keyButton.requestFocus();
            }
        });
        this.rangeFader = new LabelledFader(this, 1, "Range", 0.5, 0.0, 1.0);
        this.rangeFader.setBackground(this.rangeColor);
        topPanel.add(this.rangeFader);
        this.ampFader = new LabelledFader(this, 0, "Amplitude", 0.5, 0.1, 5.0);
        topPanel.add(this.ampFader);
        this.ampFader.getFader().setTaper(1);
        Panel faderPanel = new Panel();
        this.faders = new ChebyshevFader[16];
        faderPanel.setLayout(new GridLayout(1, 0));
        int i = 0;
        while (i < 16) {
            this.faders[i] = new ChebyshevFader(this, i);
            faderPanel.add(this.faders[i]);
            ++i;
        }
        controlPanel.add(faderPanel);
        this.drawingPad = new TableDrawingPad(this.table, this.chebData, false);
        this.drawingPad.setBackground(new Color(225, 235, 160));
        this.drawingPad.setSelectionColor(this.rangeColor);
        this.drawingPad.setForeground(Color.black);
        this.drawingPad.resize(600, 400);
        this.add("Center", this.drawingPad);
        this.scope = new SynthScope();
        this.scope.createProbe(this.gain.output, "mixed", Color.yellow);
        this.scope.finish();
        this.scope.hideControls();
        this.scopeDialog = new Dialog(SynthAlert.getFrame(this), "JSyn Scope");
        this.scopeDialog.add("Center", this.scope);
        this.scopeDialog.reshape(200, 100, 500, 400);
        this.scopeDialog.show();
        this.faders[1].setValue(0.5);
        this.keyButton.requestFocus();
        this.getParent().validate();
        this.getToolkit().sync();
    }

    double sumAbsolutes(double[] dar) {
        double sum = 0.0;
        int i = 0;
        while (i < dar.length) {
            sum += Math.abs(dar[i]);
            ++i;
        }
        return sum;
    }

    void updateTable() {
        Polynomial poly = Polynomial.mult(this.levels[0], this.chebyshevs[0]);
        int i = 1;
        while (i < 16) {
            Polynomial temp = Polynomial.mult(this.levels[i], this.chebyshevs[i]);
            poly = Polynomial.plus(poly, temp);
            ++i;
        }
        double sum = this.sumAbsolutes(this.levels);
        if (sum < 1.0) {
            sum = 1.0;
        }
        double scaleFactor = 1.0 / sum;
        poly = Polynomial.mult(scaleFactor, poly);
        double xInterval = 2.0 / (double)(this.chebData.length - 1);
        int i2 = 0;
        while (i2 < this.chebData.length) {
            double x = (double)i2 * xInterval - 1.0;
            this.chebData[i2] = poly.evaluate(x);
            ++i2;
        }
        this.table.write(this.chebData);
        this.drawingPad.repaint();
    }

    void setOrderLevel(int index, double level) {
        this.levels[index] = level;
        this.updateTable();
        this.keyButton.requestFocus();
    }

    void clearLevels() {
        int i = 0;
        while (i < 16) {
            this.faders[i].setValue(0.0);
            ++i;
        }
    }

    public void setupSynth() {
        this.levels = new double[16];
        this.keyPlayer = new PolyKeyPlayer();
        this.keys = "zxcvbnmasdfghjqwertyu1234567890";
        this.keyPlayer.setKeys(this.keys);
        this.septatonic = this.buildScale(this.keys.length(), 100.0, this.septatonicOctave);
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            this.table = new SynthTable(256);
            this.rangeLag = new ExponentialLag();
            this.chebData = new double[256];
            this.chebyshevs = new Polynomial[16];
            int i = 0;
            while (i < 16) {
                this.chebyshevs[i] = ChebyshevPolynomial.T(i);
                ++i;
            }
            double[] rangeData = new double[]{0.1, 1.0, 2.0, 0.01};
            this.rangeEnvelope = new SynthEnvelope(rangeData);
            this.rangeEnvelope.setSustainLoop(1, 1);
            this.voiceAllocator = new BussedVoiceAllocator(5){

                @Override
                public SynthCircuit makeVoice() throws SynthException {
                    WaveShapingOscillator wosc = new WaveShapingOscillator(PlayWaveShaper.this.table);
                    wosc.setRangeEnvelope(PlayWaveShaper.this.rangeEnvelope);
                    PlayWaveShaper.this.rangeLag.output.connect(wosc.range);
                    return this.addVoiceToMix(wosc);
                }
            };
            int now = Synth.getTickCount();
            this.onVoice = (WaveShapingOscillator)this.voiceAllocator.steal(now, now + 0x3FFFFFFF, 10);
            this.chebyVoices = new PitchedVoices(this.voiceAllocator, this.septatonic);
            this.keyPlayer.setVoices(this.chebyVoices);
            this.keyPlayer.setAmplitude(1.0);
            this.gainLag = new ExponentialLag();
            this.gain = new MultiplyUnit();
            this.lineOut = new LineOut();
            this.voiceAllocator.output.connect(this.gain.inputA);
            this.gainLag.output.connect(this.gain.inputB);
            this.gain.output.connect(0, this.lineOut.input, 0);
            this.gain.output.connect(0, this.lineOut.input, 1);
            this.rangeLag.start();
            this.gainLag.start();
            this.gain.start();
            this.lineOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void start() {
        this.setupSynth();
        this.setupGUI();
        this.setRange(0.5);
    }

    @Override
    public void stop() {
        this.lineOut.delete();
        this.lineOut = null;
        this.voiceAllocator.stop();
        this.voiceAllocator.delete();
        this.voiceAllocator = null;
        this.removeAll();
        Synth.verbosity = 0;
        Synth.stopEngine();
    }
}

