/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.view102.CustomFader;
import com.softsynth.jsyn.view102.CustomFaderListener;
import compmus.SignalDisplay;
import compmus.SpinningPhaser;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;

public class SampledPhaser
extends Applet
implements CustomFaderListener,
Runnable {
    static final int FADER_RANGE = 256;
    static final int QUANTIZED_RANGE = 1024;
    static final int NUM_SAMPLES = 64;
    static final int QUANTIZED_MAX = 1023;
    static final int min_WY = 0;
    static final int max_WY = 1024;
    CustomFader customFader;
    int[] sampledData;
    SignalDisplay xyplot;
    SpinningPhaser phaser;
    Thread thread;
    volatile boolean go;
    int currentValue = 512;

    public static void main(String[] args) {
        SampledPhaser applet = new SampledPhaser();
        AppletFrame frame = new AppletFrame("SampledPhaser", applet);
        frame.resize(500, 290);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.sampledData = new int[64];
        this.setLayout(new BorderLayout());
        Panel signalPanel = new Panel();
        this.add("Center", signalPanel);
        signalPanel.setLayout(new GridLayout(1, 0));
        this.xyplot = new SignalDisplay(this.sampledData, 0.0, 1024.0);
        signalPanel.add(this.xyplot);
        this.phaser = new SpinningPhaser();
        signalPanel.add(this.phaser);
        this.customFader = new CustomFader(0, 0, 10, 0, 256){

            @Override
            public Dimension preferredSize() {
                return new Dimension(100, 40);
            }
        };
        this.customFader.addCustomFaderListener(this);
        this.customFader.setBlockIncrement(10);
        this.customFader.setUnitIncrement(1);
        this.add("South", this.customFader);
        this.getParent().validate();
        this.getToolkit().sync();
        this.go = true;
        this.thread = new Thread(this);
        this.thread.start();
        this.phaser.setIncrement(0.0);
        this.phaser.start();
    }

    @Override
    public void stop() {
        this.phaser.stop();
        this.removeAll();
        this.go = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (this.go) {
            int[] nArray = this.sampledData;
            // MONITORENTER : this.sampledData
            int i = 0;
            while (true) {
                if (i >= 63) {
                    this.sampledData[63] = (int)(1024.0 * (0.5 * Math.sin(this.phaser.getAngle()) + 0.5));
                    this.xyplot.repaint();
                    // MONITOREXIT : nArray
                    break;
                }
                this.sampledData[i] = this.sampledData[i + 1];
                ++i;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void customFaderValueChanged(Object fader, int value) {
        this.phaser.setIncrement(0.004 * (double)value);
    }
}

