/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.LinearLag;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthTablePort;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.WaveShaper;

public class ScrubbingCircuit
extends SynthCircuit {
    static final boolean useLinearLag = true;
    static final double LINLAG_TIME = 0.06;
    ExponentialLag expLagPosition;
    LinearLag linLagPosition;
    WaveShaper waveShaper = new WaveShaper();
    EnvelopePlayer envPlayer;
    SynthEnvelope envelope;
    EnvelopePlayer drivingEnvPlayer;
    SynthEnvelope drivingEnvelope;
    SynthOutput lagOutput;
    boolean envelopeDriven;
    public SynthVariable input;
    public SynthVariable time;
    public SynthVariable halfLife;
    public SynthTablePort tablePort;

    public ScrubbingCircuit() throws SynthException {
        this.add(this.waveShaper);
        this.linLagPosition = new LinearLag();
        this.add(this.linLagPosition);
        this.input = this.linLagPosition.input;
        this.addPort(this.input);
        this.time = this.linLagPosition.time;
        this.addPort(this.time);
        this.time.setup(0.005, 0.06, 0.3);
        this.lagOutput = this.linLagPosition.output;
        double[] envData = new double[]{0.05, 1.0, 0.05, 0.0};
        this.envelope = new SynthEnvelope(envData);
        this.envPlayer = new EnvelopePlayer();
        this.add(this.envPlayer);
        this.drivingEnvelope = new SynthEnvelope(2);
        this.drivingEnvPlayer = new EnvelopePlayer();
        this.add(this.drivingEnvPlayer);
        this.output = this.envPlayer.output;
        this.addPort(this.output);
        this.tablePort = this.waveShaper.tablePort;
        this.addPort(this.tablePort);
        this.input.setup(-1.0, 0.0, 1.0);
        this.waveShaper.amplitude.set(0.5);
        this.waveShaper.output.connect(this.envPlayer.amplitude);
        this.envelopeDriven = true;
        this.useLag();
    }

    public double drag(double wx, double wy) {
        double pos = wx * 2.0 - 1.0;
        double dur = wy * 0.6 + 0.01;
        this.time.set(dur);
        this.linLagPosition.input.set(pos);
        this.input.set(pos);
        return pos;
    }

    synchronized void useLag() {
        if (this.envelopeDriven) {
            this.drivingEnvPlayer.envelopePort.clear();
            this.lagOutput.connect(this.waveShaper.input);
            this.envelopeDriven = false;
        }
    }

    synchronized void useEnvelope() {
        if (!this.envelopeDriven) {
            this.drivingEnvPlayer.output.connect(this.waveShaper.input);
            this.envelopeDriven = true;
        }
    }

    public void playSample(double duration) {
        double[] envData = new double[]{0.0, -1.0, duration, 1.0};
        this.drivingEnvelope.write(envData);
        this.useEnvelope();
        this.drivingEnvPlayer.envelopePort.clear();
        this.drivingEnvPlayer.envelopePort.queue(this.drivingEnvelope, 0, 2, 16);
        this.envPlayer.envelopePort.clear();
        this.envPlayer.envelopePort.queue(this.envelope, 0, 1);
        this.start();
    }

    public void down(double wx, double wy) {
        this.useLag();
        double pos = this.drag(wx, wy);
        this.linLagPosition.input.set(pos);
        this.linLagPosition.time.set(1.0E-4);
        this.envPlayer.envelopePort.clear();
        this.envPlayer.envelopePort.queue(this.envelope, 0, 1);
        this.start();
    }

    public void up(double wx, double wy) {
        double pos = this.drag(wx, wy);
        this.envPlayer.envelopePort.queue(this.envelope, 1, 1, 16);
    }

    public double getPosition() {
        double pos = 0.0;
        pos = this.envelopeDriven ? this.drivingEnvPlayer.output.get() : this.lagOutput.get();
        return pos;
    }
}

