/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthSample;
import compmus.VariableMultiTap;

public class VariableMultiTapDelay
extends SynthCircuit
implements Runnable {
    private SynthSample delayLine;
    private VariableMultiTap[] taps;
    private SampleWriter_16F1 sampleWriter;
    private BusReader busReader;
    private MultiplyAddUnit feedbackMixer;
    private int numSamples;
    private Thread thread;
    private volatile boolean go = false;
    private double maxDelayInSeconds;
    public SynthInput input;
    public SynthInput feedback;
    public SynthInput amplitude;

    public VariableMultiTapDelay(int numTaps, double delayTime) throws SynthException {
        this.taps = new VariableMultiTap[numTaps];
        this.numSamples = (int)(delayTime * Synth.getFrameRate());
        this.maxDelayInSeconds = delayTime;
        this.delayLine = new SynthSample(this.numSamples);
        this.busReader = new BusReader();
        this.add(this.busReader);
        int i = 0;
        while (i < numTaps) {
            VariableMultiTap tap;
            this.taps[i] = tap = new VariableMultiTap(this, this.delayLine);
            tap.busOutput.connect(this.busReader.busInput);
            tap.setTargetDelayInFrames((i + 1) * this.numSamples / (numTaps + 1));
            tap.setAmplitude((i & 1) == 1 ? -0.25 : 0.25);
            ++i;
        }
        this.sampleWriter = new SampleWriter_16F1();
        this.add(this.sampleWriter);
        this.feedbackMixer = new MultiplyAddUnit();
        this.add(this.feedbackMixer);
        this.sampleWriter.samplePort.queueLoop(this.delayLine, 0, this.numSamples);
        this.busReader.output.connect(this.feedbackMixer.inputA);
        this.feedbackMixer.output.connect(this.sampleWriter.input);
        this.input = this.feedbackMixer.inputC;
        this.addPort(this.input, "input");
        this.feedback = this.feedbackMixer.inputB;
        this.addPort(this.feedback, "feedback");
        this.amplitude = this.busReader.amplitude;
        this.addPort(this.amplitude);
        this.output = this.busReader.output;
        this.addPort(this.output);
    }

    public int getTapCount() {
        return this.taps.length;
    }

    public double getTapDelay(int tapIndex) {
        return this.taps[tapIndex].getDelay();
    }

    public double getMaxDelay() {
        return this.maxDelayInSeconds;
    }

    @Override
    public void start(int ticks) {
        super.start(ticks);
        this.go = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void stop(int ticks) {
        super.stop(ticks);
        this.go = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        while (this.go) {
            try {
                int numWritten = this.sampleWriter.samplePort.getNumFramesMoved();
                int i = 0;
                while (i < this.taps.length) {
                    this.taps[i].chase(numWritten);
                    ++i;
                }
                this.updateDisplay();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void updateDisplay() {
    }

    public VariableMultiTap getTap(int i) {
        return this.taps[i];
    }
}

