/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthTable;
import com.softsynth.jsyn.TableOscillator;
import com.softsynth.jsyn.view102.PortFader;
import compmus.TableDrawingPad;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;

public class WaveDrawer
extends Applet {
    SynthTable myTable;
    TableOscillator myWaveOsc;
    LineOut myOut;
    static final int WAVE_LENGTH = 256;
    TableDrawingPad drawingPad;
    Button smoothButton;

    public static void main(String[] args) {
        WaveDrawer applet = new WaveDrawer();
        AppletFrame frame = new AppletFrame("Draw a Waveform", applet);
        frame.resize(600, 700);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            this.myWaveOsc = new TableOscillator();
            this.myOut = new LineOut();
            double[] dar = new double[256];
            this.myTable = new SynthTable(dar);
            this.drawingPad = new TableDrawingPad(this.myTable, dar, true);
            this.drawingPad.setBackground(new Color(225, 235, 160));
            this.drawingPad.setForeground(Color.black);
            this.drawingPad.resize(600, 400);
            this.add("Center", this.drawingPad);
            this.myWaveOsc.tablePort.setTable(this.myTable);
            this.myWaveOsc.output.connect(0, this.myOut.input, 0);
            this.myWaveOsc.output.connect(0, this.myOut.input, 1);
            Panel faderPanel = new Panel();
            this.smoothButton = new Button("Smooth");
            faderPanel.add(this.smoothButton);
            faderPanel.setLayout(new GridLayout(0, 1));
            faderPanel.add(new PortFader(this.myWaveOsc.amplitude, 0.8, 0.0, 1.0));
            faderPanel.add(new PortFader(this.myWaveOsc.frequency, 200.0, 0.0, 800.0));
            this.add("South", faderPanel);
            this.getParent().validate();
            this.getToolkit().sync();
            this.myOut.start();
            this.myWaveOsc.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.myOut.stop();
            this.myWaveOsc.stop();
            this.removeAll();
            this.myOut.delete();
            this.myOut = null;
            this.myWaveOsc.delete();
            this.myWaveOsc = null;
            this.myTable.delete();
            this.myTable = null;
            this.drawingPad = null;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.smoothButton) {
            this.drawingPad.smooth();
            this.drawingPad.smooth();
            this.drawingPad.updateData();
            return true;
        }
        return false;
    }
}

