/*
 * Decompiled with CFR 0.152.
 */
package org.philburk.music;

import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SquareOscillatorBL;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.softsynth.shared.time.TimeStamp;

public class NicksRing
extends Circuit
implements UnitVoice {
    PassThrough frequencyPassThrough = new PassThrough();
    public UnitInputPort frequency;
    PassThrough amplitudePassThrough;
    public UnitInputPort amplitude;
    PassThrough outputPassThrough;
    public UnitOutputPort output;
    SawtoothOscillatorBL sawOscBL;
    SquareOscillatorBL squareOscBL;
    Multiply atimes;
    PassThrough amp2PassThrough;
    public UnitInputPort amp2;
    PassThrough freq2PassThrough;
    public UnitInputPort freq2;
    SegmentedEnvelope segEnv;
    VariableRateMonoReader monoRdr;

    public NicksRing() {
        this.add(this.frequencyPassThrough);
        this.frequency = this.frequencyPassThrough.input;
        this.addPort(this.frequency, "frequency");
        this.amplitudePassThrough = new PassThrough();
        this.add(this.amplitudePassThrough);
        this.amplitude = this.amplitudePassThrough.input;
        this.addPort(this.amplitude, "amplitude");
        this.outputPassThrough = new PassThrough();
        this.add(this.outputPassThrough);
        this.output = this.outputPassThrough.output;
        this.addPort(this.output, "output");
        this.sawOscBL = new SawtoothOscillatorBL();
        this.add(this.sawOscBL);
        this.squareOscBL = new SquareOscillatorBL();
        this.add(this.squareOscBL);
        this.atimes = new Multiply();
        this.add(this.atimes);
        this.amp2PassThrough = new PassThrough();
        this.add(this.amp2PassThrough);
        this.amp2 = this.amp2PassThrough.input;
        this.addPort(this.amp2, "amp2");
        this.freq2PassThrough = new PassThrough();
        this.add(this.freq2PassThrough);
        this.freq2 = this.freq2PassThrough.input;
        this.addPort(this.freq2, "freq2");
        double[] segEnvData = new double[]{0.5, 1.0, 0.08622609637131662, 0.8421052631578947, 0.026474726932898096, 0.4298245614035088, 0.06807786925602399, 0.956140350877193, 0.42435792304886233, 0.8, 0.5, 0.0};
        this.segEnv = new SegmentedEnvelope(segEnvData);
        this.segEnv.setSustainBegin(1);
        this.segEnv.setSustainEnd(4);
        this.monoRdr = new VariableRateMonoReader();
        this.add(this.monoRdr);
        this.frequencyPassThrough.output.connect(this.sawOscBL.frequency);
        this.amplitudePassThrough.output.connect(this.monoRdr.amplitude);
        this.sawOscBL.output.connect(this.atimes.inputA);
        this.squareOscBL.output.connect(this.atimes.inputB);
        this.atimes.output.connect(this.outputPassThrough.input);
        this.amp2PassThrough.output.connect(this.squareOscBL.amplitude);
        this.freq2PassThrough.output.connect(this.squareOscBL.frequency);
        this.monoRdr.output.connect(this.sawOscBL.amplitude);
        this.frequency.setup(40.0, 130.8131584, 8000.0);
        this.amplitude.setup(0.0, 0.5, 1.0);
        this.amp2.setup(0.0, 0.9999692992895746, 1.0);
        this.freq2.setup(40.0, 440.0006910393637, 8000.0);
        this.monoRdr.rate.set(1.0);
    }

    @Override
    public void noteOn(double frequency, double amplitude, TimeStamp timeStamp) {
        this.frequency.set(frequency, timeStamp);
        this.amplitude.set(amplitude, timeStamp);
        this.monoRdr.dataQueue.queueOn(this.segEnv, timeStamp);
    }

    @Override
    public void noteOff(TimeStamp timeStamp) {
        this.monoRdr.dataQueue.queueOff(this.segEnv, false, timeStamp);
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }
}

