/*
 * Decompiled with CFR 0.152.
 */
package usertest;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.circuits.PluckedString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;

class GuitarScreenC
extends JPanel {
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    private int[] stringPositions = null;
    private PluckedString[] Strings;
    private BusWriter[] Writers;
    private BusReader BR;
    private LineOut LO;

    GuitarScreenC() {
        double[] freqs = new double[]{195.997717, 246.9416506, 293.66476, 391.995435, 493.8833012561, 783.99087};
        this.LO = new LineOut();
        this.BR = new BusReader();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                GuitarScreenC.this.moveto(me.getX(), me.getY());
            }
        });
        this.Strings = new PluckedString[6];
        this.Writers = new BusWriter[6];
        int index = 0;
        while (index < this.Strings.length) {
            this.Strings[index] = new PluckedString(2.0 / freqs[index] - 3.741496598639456E-4);
            this.Strings[index].feedback.setup(1.0, 0.999, 0.9);
            this.Writers[index] = new BusWriter();
            this.Strings[index].output.connect(this.Writers[index].input);
            this.Writers[index].busOutput.connect(this.BR.busInput);
            ++index;
        }
        this.BR.output.connect(0, this.LO.input, 0);
        this.BR.output.connect(0, this.LO.input, 1);
        index = 0;
        while (index < this.Strings.length) {
            this.Strings[index].start();
            ++index;
        }
        index = 0;
        while (index < this.Strings.length) {
            this.Writers[index].start();
            ++index;
        }
        this.BR.amplitude.set(0.16666666666666666);
        this.BR.start();
        this.LO.start();
    }

    void quiet() {
        this.LO.stop();
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension ScreenSize = this.getSize();
        if (this.stringPositions == null) {
            int middle = ScreenSize.width / 2;
            this.stringPositions = new int[6];
            int index = 0;
            while (index < 6) {
                this.stringPositions[index] = middle - 75 + index * 30;
                ++index;
            }
        }
        g.setColor(Color.black);
        int index = 0;
        while (index < 6) {
            g.drawLine(this.stringPositions[index], 0, this.stringPositions[index], ScreenSize.height);
            ++index;
        }
    }

    private void moveto(int x, int y) {
        if (this.lastMouseX != -1 && this.stringPositions != null) {
            double power = Math.abs(this.lastMouseX - x);
            int index = 0;
            while (index < this.stringPositions.length) {
                if (this.lastMouseX < this.stringPositions[index] && x >= this.stringPositions[index] || this.lastMouseX >= this.stringPositions[index] && x < this.stringPositions[index]) {
                    this.Strings[index].pluck();
                }
                ++index;
            }
        }
        this.lastMouseX = x;
        this.lastMouseY = y;
    }
}

