/*
 * Decompiled with CFR 0.152.
 */
package usertest.jameslee;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.Spectrum;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SpectralFFT;
import com.jsyn.unitgen.SpectralProcessor;

public class SpectrumAnalyzer {
    public SpectrumAnalyzer() {
        Synthesizer synth = JSyn.createSynthesizer();
        CustomSpectralProcessor sp = new CustomSpectralProcessor(11);
        synth.add(sp);
        SpectralFFT fft = new SpectralFFT(11);
        synth.add(fft);
        fft.output.connect(sp.input);
        SineOscillator sine = new SineOscillator();
        sine.amplitude.set(0.5);
        sine.frequency.set(678.0);
        synth.add(sine);
        sine.output.connect(fft.input);
        synth.start();
        sp.start();
        try {
            synth.sleepFor(5.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        synth.stop();
    }

    public static void main(String[] args) {
        new SpectrumAnalyzer();
    }

    class CustomSpectralProcessor
    extends SpectralProcessor {
        private double DECIBEL100;
        private double AMPLITUDE100;

        public CustomSpectralProcessor(int size) {
            super(size);
            this.DECIBEL100 = -100.0;
            this.AMPLITUDE100 = Math.pow(10.0, this.DECIBEL100 / 20.0);
        }

        @Override
        public void processSpectrum(Spectrum inputSpectrum, Spectrum outputSpectrum) {
            double[] im = inputSpectrum.getImaginary();
            double[] re = inputSpectrum.getReal();
            double[] amps = new double[im.length];
            double max = -1000.0;
            int maxIndex = -1;
            int i = 1;
            while (i < im.length / 2) {
                amps[i] = Math.sqrt(im[i] * im[i] + re[i] * re[i]);
                amps[i] = amps[i] < this.AMPLITUDE100 ? this.DECIBEL100 : 20.0 * Math.log10(amps[i]);
                if (amps[i] > max) {
                    max = amps[i];
                    maxIndex = i;
                }
                ++i;
            }
            System.out.println("max = " + max + ", maxIndex = " + maxIndex);
        }
    }
}

