/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

import java.util.Vector;

public class Polynomial {
    private final Vector terms = new Vector();

    public Polynomial() {
    }

    public Polynomial(double d) {
        this();
        this.appendTerm(d);
    }

    public Polynomial(double d, double d2) {
        this(d2);
        this.appendTerm(d);
    }

    public Polynomial(double d, double d2, double d3) {
        this(d2, d3);
        this.appendTerm(d);
    }

    public Polynomial(double d, double d2, double d3, double d4) {
        this(d2, d3, d4);
        this.appendTerm(d);
    }

    public Polynomial(double d, double d2, double d3, double d4, double d5) {
        this(d2, d3, d4, d5);
        this.appendTerm(d);
    }

    public void appendTerm(double d) {
        this.terms.addElement(new DoubleHolder(d));
    }

    public void setTerm(double d, int n) {
        int n2 = this.terms.size();
        if (n >= n2) {
            for (int i = 0; i < n - n2 + 1; ++i) {
                this.appendTerm(0.0);
            }
        }
        ((DoubleHolder)this.terms.elementAt(n)).set(d);
    }

    public void addTerm(double d, int n) {
        this.setTerm(d + this.get(n), n);
    }

    public double get(int n) {
        if (n >= this.terms.size()) {
            return 0.0;
        }
        return ((DoubleHolder)this.terms.elementAt(n)).get();
    }

    public int size() {
        return this.terms.size();
    }

    public static Polynomial plus(Polynomial polynomial, Polynomial polynomial2) {
        Polynomial polynomial3 = new Polynomial();
        for (int i = 0; i < Math.max(polynomial.size(), polynomial2.size()); ++i) {
            polynomial3.appendTerm(polynomial.get(i) + polynomial2.get(i));
        }
        return polynomial3;
    }

    public static Polynomial minus(Polynomial polynomial, Polynomial polynomial2) {
        Polynomial polynomial3 = new Polynomial();
        for (int i = 0; i < Math.max(polynomial.size(), polynomial2.size()); ++i) {
            polynomial3.appendTerm(polynomial.get(i) - polynomial2.get(i));
        }
        return polynomial3;
    }

    public static Polynomial mult(Polynomial polynomial, Polynomial polynomial2) {
        Polynomial polynomial3 = new Polynomial();
        for (int i = 0; i < polynomial.size(); ++i) {
            for (int j = 0; j < polynomial2.size(); ++j) {
                polynomial3.addTerm(polynomial.get(i) * polynomial2.get(j), i + j);
            }
        }
        return polynomial3;
    }

    public static Polynomial mult(double d, Polynomial polynomial) {
        Polynomial polynomial2 = new Polynomial();
        for (int i = 0; i < polynomial.size(); ++i) {
            polynomial2.appendTerm(polynomial.get(i) * d);
        }
        return polynomial2;
    }

    public double evaluate(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.terms.size(); ++i) {
            d2 += this.get(i) * Math.pow(d, i);
        }
        return d2;
    }

    public String toString() {
        String string = "";
        if (this.size() == 0) {
            string = "empty polynomial";
        }
        boolean bl = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i) == 0.0) continue;
            if (bl) {
                string = string + " + ";
            }
            String string2 = "";
            if (this.get(i) != 1.0 || i == 0) {
                string2 = string2 + this.get(i);
            }
            if (i == 0) {
                string = string + string2;
            } else {
                String string3 = "";
                if (i != 1) {
                    string3 = "^" + i;
                }
                string = string + string2 + "x" + string3;
            }
            bl = true;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Polynomial polynomial = new Polynomial();
        System.out.println("p1=" + polynomial);
        Polynomial polynomial2 = new Polynomial(3.0);
        System.out.println("p2=" + polynomial2);
        Polynomial polynomial3 = new Polynomial(2.0, 3.0);
        System.out.println("p3=" + polynomial3);
        Polynomial polynomial4 = new Polynomial(1.0, 2.0, 3.0);
        System.out.println("p4=" + polynomial4);
        System.out.println("p4*5=" + Polynomial.mult(5.0, polynomial4));
        System.out.println(polynomial4.evaluate(10.0));
        System.out.println(Polynomial.plus(polynomial4, polynomial));
        System.out.println(Polynomial.minus(polynomial4, polynomial3));
        polynomial4.setTerm(12.2, 5);
        System.out.println(polynomial4);
        polynomial4.addTerm(0.8, 5);
        System.out.println(polynomial4);
        polynomial4.addTerm(0.8, 7);
        System.out.println(polynomial4);
        System.out.println(Polynomial.mult(polynomial3, polynomial2));
        System.out.println(Polynomial.mult(polynomial3, polynomial3));
        System.out.println(Polynomial.mult(polynomial2, polynomial2));
        Polynomial polynomial5 = new Polynomial(2.0, 0.0, -1.0);
        Polynomial polynomial6 = new Polynomial(4.0, 0.0, -3.0, 0.0);
        Polynomial polynomial7 = Polynomial.minus(Polynomial.mult(polynomial6, new Polynomial(2.0, 0.0)), polynomial5);
        System.out.println(polynomial5 + "\n" + polynomial6 + "\n" + polynomial7);
    }

    class DoubleHolder {
        double value;

        public DoubleHolder(double d) {
            this.value = d;
        }

        public double get() {
            return this.value;
        }

        public void set(double d) {
            this.value = d;
        }
    }
}

