/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.jsyn.swing.RotaryController;
import com.syntona.gui.patch.HeaderBox;
import com.syntona.gui.patch.ModuleView;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.ModulePresenter;
import java.awt.Insets;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KnobModuleView
extends ModuleView {
    private static final int HEIGHT = 60;
    private static final int WIDTH = 68;
    private static final int KNOB_HEIGHT = 42;
    private static final int KNOB_WIDTH = 42;

    public KnobModuleView() {
    }

    public KnobModuleView(ModulePresenter presenter) {
        super(presenter);
    }

    @Override
    public void makeJacks() {
        this.setSize(68, 60);
        Insets insets = this.getInsets();
        this.makeVerticalJackBoxes();
        InputDoubleJack inJack = (InputDoubleJack)this.getModule().getJackByName("in");
        BoundedRangeModel rangeModel = inJack.getBoundedRangeModel();
        RotaryController knob = new RotaryController(rangeModel);
        knob.setStyle(RotaryController.Style.ARC);
        knob.setSize(42, 42);
        knob.setLocation(insets.left + 8, insets.top + 10);
        this.addComponent(knob);
        rangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                KnobModuleView.this.getEngineController().sendKickModule(KnobModuleView.this.getModule());
            }
        });
    }

    @Override
    public JComponent makeHeader() {
        HeaderBox header = this.createTopHeaderBox(68);
        this.addComponent(header);
        return header;
    }
}

