/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.gui.AlertUser;
import com.syntona.model.SyntonaSaver;
import com.syntona.plugin.Jack;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.PatchListener;
import com.syntona.plugin.SyntonaModule;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class PatchModule
extends SyntonaModule {
    private final CopyOnWriteArrayList<SyntonaModule> modules = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<PatchListener> listeners = new CopyOnWriteArrayList();

    public PatchModule() {
        this.setHelp("Contains other modules.");
    }

    public void firePatchChanged() {
        for (PatchListener patchListener : this.listeners) {
            patchListener.patchChanged(this);
        }
    }

    public void addPatchListener(PatchListener patchListener) {
        this.listeners.add(patchListener);
    }

    public void removePatchListener(PatchListener patchListener) {
        this.listeners.remove(patchListener);
    }

    public void remove(SyntonaModule module) {
        module.disconnectAllJacks();
        this.modules.remove(module);
        this.firePatchChanged();
    }

    public void add(SyntonaModule addedModule) {
        this.modules.add(addedModule);
        this.firePatchChanged();
    }

    @Override
    public void shutdown() {
        for (SyntonaModule module : this.modules) {
            module.shutdown();
        }
    }

    public SyntonaModule[] getModules() {
        return this.modules.toArray(new SyntonaModule[0]);
    }

    public void saveConnections(SyntonaSaver saver) {
        saver.beginElement("connections");
        for (SyntonaModule module : this.modules) {
            Jack[] jacks;
            Jack[] jackArray = jacks = module.getJacks();
            int n = jacks.length;
            int n2 = 0;
            while (n2 < n) {
                Jack jack = jackArray[n2];
                if (jack instanceof OutputJack) {
                    OutputJack outJack = (OutputJack)jack;
                    saver.beginElement("output");
                    saver.addAttribute("id", "" + module.getSaveId());
                    saver.addAttribute("jack", outJack.getName());
                    Iterator<Jack> connected = jack.getConnected();
                    while (connected.hasNext()) {
                        Jack otherJack = connected.next();
                        SyntonaModule otherModule = otherJack.getModule();
                        saver.beginElement("input");
                        saver.addAttribute("id", "" + otherModule.getSaveId());
                        saver.addAttribute("jack", otherJack.getName());
                        saver.endElement();
                    }
                    saver.endElement();
                }
                ++n2;
            }
        }
        saver.endElement();
    }

    public int size() {
        return this.modules.size();
    }

    public void clear() {
        for (SyntonaModule module : this.modules) {
            module.disconnectAllJacks();
        }
        this.modules.clear();
        this.firePatchChanged();
    }

    public boolean validateExport() {
        AlertUser.showError("Plain patches cannot be exported. Only export JSyn voices.");
        return false;
    }
}

