/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.ports.UnitOutputPort;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.core.PatchModule;
import com.syntona.model.jsyn.InputAudioJack;
import com.syntona.model.jsyn.OutputAudioJack;
import com.syntona.model.jsyn.UnitPortModule;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModule;

public class AudioOutputJackModule
extends UnitPortModule {
    OutputAudioJack output;
    private final InputAudioJack input;

    public AudioOutputJackModule() {
        this.input = new InputAudioJack(this, "input", this.tiePoint.input, 0);
        this.input.setHelp("send to parent");
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.output != null) {
            this.output.setName(name);
        }
    }

    @Override
    public void removedFromPatch() {
        this.getParent().removeJack(this.output);
        super.removedFromPatch();
    }

    @Override
    public void addedToPatch(PatchModule parent) {
        super.addedToPatch(parent);
        this.output = new OutputAudioJack((SyntonaModule)parent, this.getName(), "output from patch");
        this.output.setSynthPort(this.tiePoint.output);
    }

    @Override
    public void kick() {
        PatchMessage msg = this.input.getLastMessage();
        this.output.passMessage(msg);
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        super.exportJavaSource(exporter, phase);
        IndentingWriter writer = exporter.getWriter();
        switch (phase) {
            case 0: {
                exporter.addClass(UnitOutputPort.class);
                break;
            }
            case 1: {
                writer.println("public UnitOutputPort " + this.output.getName() + ";");
                break;
            }
            case 3: {
                writer.println("addPort( " + this.output.getName() + " = " + this.getExportName() + ".output, \"" + this.output.getName() + "\");");
            }
        }
    }
}

