/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.FloatSample;
import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.AsymptoticRamp;
import com.jsyn.unitgen.Compare;
import com.jsyn.unitgen.ContinuousRamp;
import com.jsyn.unitgen.Divide;
import com.jsyn.unitgen.EdgeDetector;
import com.jsyn.unitgen.EnvelopeAttackDecay;
import com.jsyn.unitgen.EnvelopeDAHDSR;
import com.jsyn.unitgen.ExponentialRamp;
import com.jsyn.unitgen.FilterAllPass;
import com.jsyn.unitgen.FilterBandPass;
import com.jsyn.unitgen.FilterBandStop;
import com.jsyn.unitgen.FilterFourPoles;
import com.jsyn.unitgen.FilterHighPass;
import com.jsyn.unitgen.FilterHighShelf;
import com.jsyn.unitgen.FilterLowPass;
import com.jsyn.unitgen.FilterLowShelf;
import com.jsyn.unitgen.FilterPeakingEQ;
import com.jsyn.unitgen.FixedRateMonoWriter;
import com.jsyn.unitgen.ImpulseOscillator;
import com.jsyn.unitgen.ImpulseOscillatorBL;
import com.jsyn.unitgen.Latch;
import com.jsyn.unitgen.LatchZeroCrossing;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.Maximum;
import com.jsyn.unitgen.Minimum;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.MultiplyAdd;
import com.jsyn.unitgen.PeakFollower;
import com.jsyn.unitgen.PhaseShifter;
import com.jsyn.unitgen.PinkNoise;
import com.jsyn.unitgen.PitchDetector;
import com.jsyn.unitgen.PowerOfTwo;
import com.jsyn.unitgen.PulseOscillator;
import com.jsyn.unitgen.PulseOscillatorBL;
import com.jsyn.unitgen.RangeConverter;
import com.jsyn.unitgen.RedNoise;
import com.jsyn.unitgen.SawtoothOscillator;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SawtoothOscillatorDPW;
import com.jsyn.unitgen.SchmidtTrigger;
import com.jsyn.unitgen.Select;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SineOscillatorPhaseModulated;
import com.jsyn.unitgen.SquareOscillator;
import com.jsyn.unitgen.SquareOscillatorBL;
import com.jsyn.unitgen.Subtract;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.jsyn.unitgen.WhiteNoise;
import com.syntona.model.jsyn.AudioInputJackModule;
import com.syntona.model.jsyn.AudioOutputJackModule;
import com.syntona.model.jsyn.AudioScopeModule;
import com.syntona.model.jsyn.Delay1Presenter;
import com.syntona.model.jsyn.FloatSampleModulePresenter;
import com.syntona.model.jsyn.JSynMixer;
import com.syntona.model.jsyn.JSynModuleInfo;
import com.syntona.model.jsyn.JSynToolBar;
import com.syntona.model.jsyn.MixerMono4Presenter;
import com.syntona.model.jsyn.MixerMono8Presenter;
import com.syntona.model.jsyn.MixerStereo4Presenter;
import com.syntona.model.jsyn.MixerStereo8Presenter;
import com.syntona.model.jsyn.NotePlayerModel;
import com.syntona.model.jsyn.ScopeModuleView;
import com.syntona.model.jsyn.SegmentedEnvelopeModulePresenter;
import com.syntona.model.jsyn.StereoOutModule;
import com.syntona.model.jsyn.UnitVoiceModulePresenter;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.ModuleInfo;
import java.util.logging.Logger;
import javax.swing.JToolBar;

public class JSynBundle
extends Bundle {
    protected static final String JSYN_JAVADOCS_URL_PREFIX = "http://www.softsynth.com/jsyn/docs/javadocs/";
    private static Logger logger = Logger.getLogger(JSynBundle.class.getName());
    private static JSynBundle instance = null;
    private static Synthesizer synth;
    private static String GROUP_ANALYSIS;
    private static String GROUP_CONTROL;
    private static String GROUP_DATA;
    private static String GROUP_EFFECTS;
    private static String GROUP_FILTERS;
    private static String GROUP_MATH;
    private static String GROUP_MISC;
    private static String GROUP_MIXERS;
    private static String GROUP_SOURCES;
    private static JSynMixer mixer;
    private JToolBar toolbar;
    private int sampleRate = 44100;

    static {
        GROUP_ANALYSIS = "analysis";
        GROUP_CONTROL = "control";
        GROUP_DATA = "data";
        GROUP_EFFECTS = "effects";
        GROUP_FILTERS = "filters";
        GROUP_MATH = "math";
        GROUP_MISC = "misc";
        GROUP_MIXERS = "mixers";
        GROUP_SOURCES = "sources";
    }

    public static JSynBundle getInstance() {
        if (instance == null) {
            instance = new JSynBundle();
        }
        return instance;
    }

    public static Synthesizer getSynthesizer() {
        if (synth == null) {
            synth = JSyn.createSynthesizer();
        }
        return synth;
    }

    @Override
    public String getName() {
        return "jsyn";
    }

    @Override
    public void addClasses() {
        this.addModule(null, "lineOut", StereoOutModule.class);
        this.addModule("voice", UnitVoiceModulePresenter.class);
        this.addJSynUnit(GROUP_SOURCES, "sineOsc", SineOscillator.class);
        this.addJSynUnit(GROUP_SOURCES, "sineOscPM", SineOscillatorPhaseModulated.class);
        this.addJSynUnit(GROUP_SOURCES, "sawOsc", SawtoothOscillator.class);
        this.addJSynUnit(GROUP_SOURCES, "sawOscBL", SawtoothOscillatorBL.class);
        this.addJSynUnit(GROUP_SOURCES, "sawOsDPW", SawtoothOscillatorDPW.class);
        this.addJSynUnit(GROUP_SOURCES, "squareOsc", SquareOscillator.class);
        this.addJSynUnit(GROUP_SOURCES, "squareOscBL", SquareOscillatorBL.class);
        this.addJSynUnit(GROUP_SOURCES, "impulse", ImpulseOscillator.class);
        this.addJSynUnit(GROUP_SOURCES, "impulseBL", ImpulseOscillatorBL.class);
        this.addJSynUnit(GROUP_SOURCES, "pulseOsc", PulseOscillator.class);
        this.addJSynUnit(GROUP_SOURCES, "pulseOscBL", PulseOscillatorBL.class);
        this.addJSynUnit(GROUP_SOURCES, "whiteNoise", WhiteNoise.class);
        this.addJSynUnit(GROUP_SOURCES, "redNoise", RedNoise.class);
        this.addJSynUnit(GROUP_SOURCES, "pinkNoise", PinkNoise.class);
        this.addModule(GROUP_MISC, "notePlayer", NotePlayerModel.class);
        this.addModule(GROUP_MISC, "aInput", AudioInputJackModule.class);
        this.addModule(GROUP_MISC, "aOutput", AudioOutputJackModule.class);
        this.addModule(GROUP_MISC, "scope", AudioScopeModule.class, ScopeModuleView.class);
        this.addJSynUnit(GROUP_ANALYSIS, "edgeDetector", EdgeDetector.class);
        this.addJSynUnit(GROUP_ANALYSIS, "peakFollower", PeakFollower.class);
        this.addJSynUnit(GROUP_ANALYSIS, "pitchDetector", PitchDetector.class);
        this.addJSynUnit(GROUP_ANALYSIS, "schmidtTrigger", SchmidtTrigger.class);
        this.addJSynUnit(GROUP_CONTROL, "DAHDSR", EnvelopeDAHDSR.class);
        this.addJSynUnit(GROUP_CONTROL, "envAD", EnvelopeAttackDecay.class);
        this.addJSynUnit(GROUP_CONTROL, "latch", Latch.class);
        this.addJSynUnit(GROUP_CONTROL, "latchZC", LatchZeroCrossing.class);
        this.addJSynUnit(GROUP_CONTROL, "rampLin", LinearRamp.class);
        this.addJSynUnit(GROUP_CONTROL, "rampCon", ContinuousRamp.class);
        this.addJSynUnit(GROUP_CONTROL, "rampAsym", AsymptoticRamp.class);
        this.addJSynUnit(GROUP_CONTROL, "rampExp", ExponentialRamp.class);
        this.addJSynUnit(GROUP_CONTROL, "select", Select.class);
        ModuleInfo info = this.addModule(GROUP_DATA, "segEnv", SegmentedEnvelopeModulePresenter.class);
        String webpageName = JSynBundle.createJSynHelp(SegmentedEnvelope.class);
        info.setupJavaDocHelp(webpageName);
        info = this.addModule(GROUP_DATA, "sample", FloatSampleModulePresenter.class);
        webpageName = JSynBundle.createJSynHelp(FloatSample.class);
        info.setupJavaDocHelp(webpageName);
        this.addJSynUnit(GROUP_DATA, "monoRdr", VariableRateMonoReader.class);
        this.addJSynUnit(GROUP_DATA, "monoWtr", FixedRateMonoWriter.class);
        this.addJSynUnit(GROUP_MATH, "a+", Add.class, "aplus");
        this.addJSynUnit(GROUP_MATH, "a-", Subtract.class, "aminus");
        this.addJSynUnit(GROUP_MATH, "a*", Multiply.class, "atimes");
        this.addJSynUnit(GROUP_MATH, "a*+", MultiplyAdd.class, "amuladd");
        this.addJSynUnit(GROUP_MATH, "a/", Divide.class, "adivide");
        this.addJSynUnit(GROUP_MATH, "a>", Compare.class, "agt");
        this.addJSynUnit(GROUP_MATH, "aPower2", PowerOfTwo.class);
        this.addJSynUnit(GROUP_MATH, "aMin", Minimum.class);
        this.addJSynUnit(GROUP_MATH, "aMax", Maximum.class);
        this.addJSynUnit(GROUP_MATH, "aRanger", RangeConverter.class);
        this.addJSynUnit(GROUP_FILTERS, "lowPass", FilterLowPass.class);
        this.addJSynUnit(GROUP_FILTERS, "bandPass", FilterBandPass.class);
        this.addJSynUnit(GROUP_FILTERS, "bandStop", FilterBandStop.class);
        this.addJSynUnit(GROUP_FILTERS, "highPass", FilterHighPass.class);
        this.addJSynUnit(GROUP_FILTERS, "allPass", FilterAllPass.class);
        this.addJSynUnit(GROUP_FILTERS, "lowShelf", FilterLowShelf.class);
        this.addJSynUnit(GROUP_FILTERS, "highShelf", FilterHighShelf.class);
        this.addJSynUnit(GROUP_FILTERS, "peakingEQ", FilterPeakingEQ.class);
        this.addJSynUnit(GROUP_FILTERS, "fourPole", FilterFourPoles.class);
        this.addJSynUnit(GROUP_EFFECTS, "phaseShifter", PhaseShifter.class);
        this.addModule(GROUP_EFFECTS, "delay1", Delay1Presenter.class);
        this.addModule(GROUP_MIXERS, "mix4x1", MixerMono4Presenter.class);
        this.addModule(GROUP_MIXERS, "mix8x1", MixerMono8Presenter.class);
        this.addModule(GROUP_MIXERS, "mix4x2", MixerStereo4Presenter.class);
        this.addModule(GROUP_MIXERS, "mix8x2", MixerStereo8Presenter.class);
    }

    private void addJSynUnit(String group, String type, Class<?> synthClass) {
        this.addJSynUnit(group, type, synthClass, type);
    }

    private JSynModuleInfo addJSynUnit(String group, String type, Class<?> synthClass, String legalString) {
        JSynModuleInfo info = new JSynModuleInfo(group, type, synthClass, legalString);
        this.addModuleInfo(info);
        return info;
    }

    @Override
    public void start() {
        logger.info("Start JSyn synthesizer using default stereo output at 44100 Hz");
        JSynBundle.getSynthesizer().start(this.sampleRate);
    }

    @Override
    public void stop() {
        JSynBundle.getSynthesizer().stop();
    }

    @Override
    public JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JSynToolBar(JSynBundle.getMixer());
        }
        return this.toolbar;
    }

    protected static String createJSynHelp(Class<?> moduleClass) {
        String className = moduleClass.getName();
        String classWithSlashes = className.replace('.', '/');
        String webpageName = JSYN_JAVADOCS_URL_PREFIX + classWithSlashes + ".html";
        return webpageName;
    }

    public static JSynMixer getMixer() {
        if (mixer == null) {
            mixer = new JSynMixer(JSynBundle.getSynthesizer());
        }
        return mixer;
    }
}

