/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.swing.RotaryController;
import com.jsyn.unitgen.MixerMono;
import com.syntona.gui.patch.HeaderBox;
import com.syntona.gui.patch.ModuleView;
import com.syntona.model.jsyn.MixerUnitModule;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.ModulePresenter;
import java.awt.Insets;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;

public class MixerView
extends ModuleView {
    private static final int KNOB_WIDTH = 54;
    private static final int KNOB_HEIGHT = 40;
    private MixerUnitModule mixerModule;

    public MixerView() {
    }

    public MixerView(ModulePresenter presenter) {
        super(presenter);
    }

    @Override
    public void makeJacks() {
        Jack[] jacks;
        this.makeVerticalJackBoxes();
        Insets insets = this.getInsets();
        int gainIndex = 0;
        int panIndex = 0;
        Jack[] jackArray = jacks = this.getModule().getJacks();
        int n = jacks.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray[n2];
            if (jack.getName().startsWith("gain") || jack.getName().startsWith("amplitude")) {
                this.addJackKnob(insets, gainIndex++, 0, ((InputDoubleJack)jack).getBoundedRangeModel());
            }
            if (jack.getName().startsWith("pan")) {
                RotaryController knob = this.addJackKnob(insets, panIndex++, 1, ((InputDoubleJack)jack).getBoundedRangeModel());
                knob.setBaseValue(0.5);
            }
            ++n2;
        }
    }

    private void setupSize() {
        this.mixerModule = (MixerUnitModule)this.getModule();
        MixerMono mixerMono = (MixerMono)this.mixerModule.getSound();
        int numParts = mixerMono.gain.getNumParts();
        int numOutputs = mixerMono.getNumOutputs();
        int width = 16 + numOutputs * 54;
        Insets insets = this.getInsets();
        this.setSize(width, (numParts + 1) * 40 + insets.top + insets.bottom + 10);
    }

    private RotaryController addJackKnob(Insets insets, int row, int column, BoundedRangeModel rangeModel) {
        RotaryController knob = new RotaryController(rangeModel);
        knob.setStyle(RotaryController.Style.ARC);
        knob.setSize(54, 40);
        knob.setLocation(insets.left + 4 + column * 54, insets.top + 40 * row + 10);
        this.addComponent(knob);
        return knob;
    }

    @Override
    public JComponent makeHeader() {
        this.setupSize();
        HeaderBox header = this.createTopHeaderBox(this.getWidth());
        this.addComponent(header);
        return header;
    }
}

