/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.swing.EnvelopePoints;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.jsyn.SequentialDataModuleBase;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;

public class SegmentedEnvelopeModule
extends SequentialDataModuleBase {
    final SegmentedEnvelope envelope = (SegmentedEnvelope)this.getSequentialData();
    final EnvelopePoints points = new EnvelopePoints();
    private static final int MAX_POINTS = 64;

    public SegmentedEnvelopeModule() {
        super(new SegmentedEnvelope(64));
        this.points.setName("env");
        this.points.add(0.5, 1.0);
        this.points.add(0.5, 0.2);
        this.points.add(0.5, 0.8);
        this.points.add(0.5, 0.0);
        this.points.updateEnvelope(this.envelope);
    }

    public EnvelopePoints getPoints() {
        return this.points;
    }

    public int getMaxPoints() {
        return 64;
    }

    @Override
    protected void sendQueueCommand(int opcode) {
        this.points.updateEnvelopeIfDirty(this.envelope);
        super.sendQueueCommand(opcode);
    }

    void writeEnvelopeFrame(SyntonaSaver saver, double duration, double value) throws ParserConfigurationException {
        saver.beginElement("frame");
        saver.addAttribute("dur", duration);
        saver.addAttribute("value", value);
        saver.endElement();
    }

    void writeEnvelopeLoop(SyntonaSaver saver, String loopName, int begin, int end) throws ParserConfigurationException {
        saver.beginElement("loop");
        saver.addAttribute("name", loopName);
        saver.addAttribute("begin", begin);
        saver.addAttribute("end", end);
        saver.endElement();
    }

    @Override
    public void saveContents(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        saver.beginElement("envelope");
        saver.addAttribute("immediate", this.immediate);
        saver.beginElement("frames");
        int i = 0;
        while (i < this.points.size()) {
            double[] dar = this.points.getPoint(i);
            this.writeEnvelopeFrame(saver, dar[0], dar[1]);
            ++i;
        }
        saver.endElement();
        saver.beginElement("loops");
        this.writeEnvelopeLoop(saver, "sustain", this.points.getSustainBegin(), this.points.getSustainEnd());
        this.writeEnvelopeLoop(saver, "release", this.points.getReleaseBegin(), this.points.getReleaseEnd());
        saver.endElement();
        saver.endElement();
    }

    @Override
    public void loadContents(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException {
        Element envelopeElement = XMLDOMLoader.getChildByTagName(moduleElement, "envelope");
        if (envelopeElement != null) {
            List<Element> loopList;
            Element loopsElement;
            List<Element> frameList;
            this.immediate = XMLDOMLoader.parseBooleanAttribute(envelopeElement, "immediate", this.immediate);
            this.points.clear();
            Element framesElement = XMLDOMLoader.getChildByTagName(envelopeElement, "frames");
            if (framesElement != null && (frameList = XMLDOMLoader.getChildrenByTagName(framesElement, "frame")) != null) {
                int i = 0;
                while (i < frameList.size()) {
                    Element frameElement = frameList.get(i);
                    double dur = XMLDOMLoader.parseDoubleAttribute(frameElement, "dur");
                    double value = XMLDOMLoader.parseDoubleAttribute(frameElement, "value");
                    this.points.add(dur, value);
                    ++i;
                }
            }
            if ((loopsElement = XMLDOMLoader.getChildByTagName(envelopeElement, "loops")) != null && (loopList = XMLDOMLoader.getChildrenByTagName(loopsElement, "loop")) != null) {
                int i = 0;
                while (i < loopList.size()) {
                    Element loopElement = loopList.get(i);
                    String name = loopElement.getAttribute("name");
                    int begin = XMLDOMLoader.parseIntegerAttribute(loopElement, "begin");
                    int end = XMLDOMLoader.parseIntegerAttribute(loopElement, "end");
                    if ("sustain".equals(name)) {
                        this.points.setSustainLoop(begin, end);
                    } else if ("release".equals(name)) {
                        this.points.setReleaseLoop(begin, end);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        super.exportJavaSource(exporter, phase);
        IndentingWriter writer = exporter.getWriter();
        switch (phase) {
            case 0: {
                exporter.addClass(SegmentedEnvelope.class);
                break;
            }
            case 1: {
                writer.println("SegmentedEnvelope " + this.getExportName() + ";");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                String dataName = String.valueOf(this.getExportName()) + "Data";
                writer.println("double[] " + dataName + " = {");
                writer.indent();
                int i = 0;
                while (i < this.points.size()) {
                    double[] dar = this.points.getPoint(i);
                    writer.println(String.valueOf(dar[0]) + ", " + dar[1] + ",");
                    ++i;
                }
                writer.undent();
                writer.println("};");
                writer.println(String.valueOf(this.getExportName()) + " = new SegmentedEnvelope( " + dataName + " );");
                if (this.points.getSustainBegin() >= 0) {
                    writer.println(String.valueOf(this.getExportName()) + ".setSustainBegin( " + this.points.getSustainBegin() + " );");
                    writer.println(String.valueOf(this.getExportName()) + ".setSustainEnd( " + this.points.getSustainEnd() + " );");
                }
                if (this.points.getReleaseBegin() < 0) break;
                writer.println(String.valueOf(this.getExportName()) + ".setReleaseBegin( " + this.points.getReleaseBegin() + " );");
                writer.println(String.valueOf(this.getExportName()) + ".setReleaseEnd( " + this.points.getReleaseEnd() + " );");
                break;
            }
            case 7: {
                this.exportQueueToConnected(writer, "queueOn", ", timeStamp");
                break;
            }
            case 8: {
                this.exportQueueToConnected(writer, "queueOff", ", false, timeStamp");
            }
        }
    }
}

