/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.softsynth.math.AudioMath;
import com.syntona.model.SyntonaCommand;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.model.jsyn.JSynBundle;
import com.syntona.model.jsyn.UnitVoiceModule;
import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.SyntonaPluginServices;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class UnitVoiceModulePresenter
extends PatchModulePresenter {
    static String keyboard = "zxcvbnmasdfghjqwertyu12345678";
    private UnitVoiceModule unitVoiceModule = (UnitVoiceModule)this.getModule();
    private KeyListener playKeyListener;
    private InputActionJack inJack = (InputActionJack)this.unitVoiceModule.getJackByName("on");
    private JButton addPortsButton;

    public UnitVoiceModulePresenter() {
        super(new UnitVoiceModule());
        this.playKeyListener = new VoiceKeyListener();
        SyntonaPluginServices.getInstance().addPlayKeyListener(this.playKeyListener);
    }

    double convertIndexToFreq(int index) {
        int pitch = this.convertIndexToPitch(index);
        return AudioMath.pitchToFrequency(pitch + 48);
    }

    private int convertIndexToPitch(int index) {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        int[] scale = nArray;
        int octave = index / scale.length;
        int idx = index % scale.length;
        return octave * 12 + scale[idx];
    }

    protected void noteOnMaybe(char key) {
        int index;
        if (this.isGlobalNoteOnEnabled() && (index = keyboard.indexOf(key)) >= 0) {
            double freq = this.convertIndexToFreq(index);
            this.unitVoiceModule.noteOn(freq, 0.5);
        }
    }

    private boolean isGlobalNoteOnEnabled() {
        return this.inJack.getConnectedCount() == 0 && !(this.getParent() instanceof UnitVoiceModulePresenter);
    }

    protected void noteOffMaybe(char key) {
        if (this.isGlobalNoteOnEnabled()) {
            this.unitVoiceModule.noteOff();
        }
    }

    @Override
    public void delete() {
        if (this.playKeyListener != null) {
            SyntonaPluginServices.getInstance().removePlayKeyListener(this.playKeyListener);
            this.playKeyListener = null;
        }
        super.delete();
    }

    @Override
    public void addCustomTools(JToolBar toolbar) {
        this.addPortsButton = new JButton("Add Stock Ports");
        toolbar.add(this.addPortsButton);
        this.addPortsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UnitVoiceModulePresenter.this.addStockPorts();
            }
        });
        this.addPortsButton.setToolTipText("Add prequency, amplitude, and output ports.");
    }

    protected void addStockPorts() {
        SyntonaEngine.getInstance().send(new SyntonaCommand(){

            @Override
            public void execute() {
                UnitVoiceModulePresenter.this.addStockPortsNow();
            }

            @Override
            public void undo() {
            }
        });
    }

    private void addStockPortsNow() {
        int y = 20;
        int x = 30;
        if (!this.isNameInUse("frequency")) {
            ModulePresenter freqPresenter = SyntonaEngine.getInstance().addModuleNow(JSynBundle.getInstance(), this, "aInput", x, y);
            freqPresenter.getModule().setName("frequency");
            this.addUniqueName("frequency");
        }
        y += 80;
        if (!this.isNameInUse("amplitude")) {
            ModulePresenter ampPresenter = SyntonaEngine.getInstance().addModuleNow(JSynBundle.getInstance(), this, "aInput", x, y);
            ampPresenter.getModule().setName("amplitude");
            this.addUniqueName("amplitude");
        }
        y = 20;
        x = this.getPatchFrame().getWidth() - 150;
        if (!this.isNameInUse("output")) {
            ModulePresenter outputPresenter = SyntonaEngine.getInstance().addModuleNow(JSynBundle.getInstance(), this, "aOutput", x, y);
            outputPresenter.getModule().setName("output");
            this.addUniqueName("output");
        }
    }

    private class VoiceKeyListener
    implements KeyListener {
        private char lastKeyDown;

        private VoiceKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            char key = e.getKeyChar();
            if ((key = Character.toLowerCase(key)) != this.lastKeyDown) {
                this.lastKeyDown = key;
                UnitVoiceModulePresenter.this.noteOnMaybe(key);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            char key = e.getKeyChar();
            if ((key = Character.toLowerCase(key)) == this.lastKeyDown) {
                this.lastKeyDown = '\u0000';
                UnitVoiceModulePresenter.this.noteOffMaybe(key);
            }
        }
    }
}

