/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.syntona.model.music.BeatClock;
import com.syntona.model.music.BeatTimerTask;

public class BeatTimer {
    private BeatTimerTask task;
    private int ppqPerTick;
    private int counter = 0;
    private int divisor = 1;

    public void scheduleTask(BeatTimerTask task, int divisor) {
        if (this.task != null) {
            throw new IllegalArgumentException("timer in use");
        }
        this.task = task;
        this.setDivisor(divisor);
        BeatClock.getInstance().scheduleTimer(this);
    }

    public void run() {
        this.task.execute(this.counter++);
    }

    public long getNextPPQ() {
        return (this.counter + 1) * this.ppqPerTick;
    }

    public void rewind() {
        this.counter = 0;
    }

    public void updateCounter(long ppq) {
        this.counter = (int)(ppq / (long)this.ppqPerTick);
    }

    public void setDivisor(int divisor) {
        this.divisor = divisor;
        long ppq = this.getNextPPQ();
        this.ppqPerTick = 1680 / divisor;
        this.updateCounter(ppq);
    }

    public int getDivisor() {
        return this.divisor;
    }
}

