/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.syntona.model.music.BeatClock;
import com.syntona.plugin.JTextFieldDouble;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class MusicToolBar
extends JToolBar {
    private JButton startButton;
    private BeatClock beatClock;
    private JButton pauseButton;
    private JButton rewindButton;

    public MusicToolBar(BeatClock beatClock) {
        this.beatClock = beatClock;
        this.setupGUI();
    }

    private void setupGUI() {
        FlowLayout layout = new FlowLayout();
        this.setLayout(layout);
        layout.setHgap(4);
        this.add(new JLabel("Music:"));
        this.rewindButton = new JButton("Rewind");
        this.rewindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MusicToolBar.this.beatClock.rewind();
            }
        });
        this.add(this.rewindButton);
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MusicToolBar.this.beatClock.start();
            }
        });
        this.add(this.startButton);
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MusicToolBar.this.beatClock.pause();
            }
        });
        this.add(this.pauseButton);
        JTextFieldDouble tempoField = new JTextFieldDouble(this.beatClock.getTempoModel(), 6);
        this.add(tempoField);
        this.validate();
    }
}

