/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.data.SequentialData;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.VariableRateDataReader;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.jsyn.util.WaveRecorder;
import java.io.File;
import java.io.IOException;

public class PlaySegmentedEnvelope {
    private Synthesizer synth;
    private UnitOscillator osc;
    private LineOut lineOut;
    private SegmentedEnvelope envelope;
    private VariableRateDataReader envelopePlayer;
    private WaveRecorder recorder;
    private static final boolean useRecorder = true;

    private void test() throws IOException {
        this.synth = JSyn.createSynthesizer();
        this.osc = new SawtoothOscillatorBL();
        this.synth.add(this.osc);
        this.envelopePlayer = new VariableRateMonoReader();
        this.synth.add(this.envelopePlayer);
        File waveFile = new File("temp_recording.wav");
        this.recorder = new WaveRecorder(this.synth, waveFile);
        System.out.println("Writing to WAV file " + waveFile.getAbsolutePath());
        double[] pairs = new double[]{0.1, 1.0, 0.2, 0.3, 0.6, 0.0};
        this.envelope = new SegmentedEnvelope(pairs);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.envelopePlayer.output.connect(this.osc.amplitude);
        this.osc.output.connect(0, this.lineOut.input, 0);
        this.osc.output.connect(0, this.lineOut.input, 1);
        this.synth.start();
        this.osc.output.connect(0, this.recorder.getInput(), 0);
        this.envelopePlayer.output.connect(0, this.recorder.getInput(), 1);
        this.recorder.start();
        this.lineOut.start();
        try {
            this.envelopePlayer.dataQueue.queue(this.envelope);
            this.synth.sleepFor(2.0);
            this.osc.frequency.set(750.0);
            this.envelopePlayer.dataQueue.queue(this.envelope, 0, 2);
            this.synth.sleepFor(2.0);
            this.envelopePlayer.dataQueue.queue(this.envelope, 2, 1);
            this.synth.sleepFor(2.0);
            this.osc.frequency.set(950.0);
            this.envelope.setSustainBegin(2);
            this.envelope.setSustainEnd(2);
            this.envelopePlayer.dataQueue.queueOn(this.envelope);
            this.synth.sleepFor(2.0);
            this.envelopePlayer.dataQueue.queueOff(this.envelope);
            this.synth.sleepFor(2.0);
            this.osc.frequency.set(350.0);
            this.envelopePlayer.dataQueue.queueLoop((SequentialData)this.envelope, 0, this.envelope.getNumFrames(), 3);
            this.synth.sleepFor(5.0);
            this.osc.frequency.set(450.0);
            this.envelopePlayer.dataQueue.queueLoop(this.envelope, 0, this.envelope.getNumFrames());
            this.envelopePlayer.rate.set(3.0);
            this.synth.sleepFor(5.0);
            this.envelopePlayer.dataQueue.queue(this.envelope, this.envelope.getNumFrames() - 1, 1);
            this.synth.sleepFor(1.0);
            if (this.recorder != null) {
                this.recorder.stop();
                this.recorder.close();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.synth.stop();
    }

    public static void main(String[] args) {
        try {
            new PlaySegmentedEnvelope().test();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

