/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.util.PseudoRandom;

public class PinkNoise
extends UnitGenerator
implements UnitSource {
    public UnitInputPort amplitude;
    public UnitOutputPort output;
    private final int NUM_ROWS = 16;
    private final int RANDOM_BITS = 24;
    private final int RANDOM_SHIFT = 8;
    private PseudoRandom randomNum;
    protected double prevNoise;
    protected double currNoise;
    private long[] rows = new long[16];
    private double scalar;
    private int runningSum;
    private int index;
    private int indexMask;

    public PinkNoise() {
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
        this.randomNum = new PseudoRandom();
        this.index = 0;
        this.indexMask = 65535;
        int pmax = 0x8800000;
        this.scalar = 1.0 / (double)pmax;
        int i = 0;
        while (i < 16) {
            this.rows[i] = 0L;
            ++i;
        }
        this.runningSum = 0;
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        int i = start;
        while (i < limit) {
            outputs[i] = this.generatePinkNoise() * amplitudes[i];
            ++i;
        }
    }

    public double generatePinkNoise() {
        this.index = this.index + 1 & this.indexMask;
        if (this.index != 0) {
            int numZeros = 0;
            int n = this.index;
            while ((n & 1) == 0) {
                n >>= 1;
                ++numZeros;
            }
            this.runningSum = (int)((long)this.runningSum - this.rows[numZeros]);
            int newRandom = this.randomNum.nextRandomInteger() >> 8;
            this.runningSum += newRandom;
            this.rows[numZeros] = newRandom;
        }
        int newRandom = this.randomNum.nextRandomInteger() >> 8;
        int sum = this.runningSum + newRandom;
        return this.scalar * (double)sum;
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }
}

